/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.testing;

import java.util.Collection;
import java.util.Map;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public class MapMatchers {
    @Nonnull
    public static <K, V> Matcher<Map<K, V>> hasSameEntriesAs(final @Nullable Map<K, V> expected) {
        return new TypeSafeMatcher<Map<K, V>>(){

            public boolean matchesSafely(Map<K, V> item) {
                boolean result;
                if (item == null && expected == null) {
                    result = true;
                } else if (item == null || expected == null || item.size() != expected.size()) {
                    result = false;
                } else {
                    result = true;
                    for (Map.Entry expectedKeyAndValue : expected.entrySet()) {
                        Object expectedKey = expectedKeyAndValue.getKey();
                        Object expectedValue = expectedKeyAndValue.getValue();
                        Object foundValue = item.get(expectedKey);
                        if (expectedValue != null ? expectedValue.equals(foundValue) : foundValue == null) {
                            result = true;
                            continue;
                        }
                        result = false;
                        break;
                    }
                }
                return result;
            }

            public void describeTo(Description description) {
                description.appendText("has same entries as ").appendValue((Object)expected);
            }
        };
    }

    @Nonnull
    public static Matcher<Map<?, ?>> hasSize(final @Nonnegative int size) {
        return new TypeSafeMatcher<Map<?, ?>>(){

            public boolean matchesSafely(@Nullable Map<?, ?> item) {
                return size == 0 ? item == null || item.isEmpty() : item != null && size == item.size();
            }

            public void describeTo(Description description) {
                description.appendText("has size ").appendValue((Object)size);
            }

            protected void describeMismatchSafely(@Nullable Map<?, ?> actual, @Nonnull Description description) {
                description.appendValue((Object)(actual != null ? actual.size() : 0)).appendText(" (Values: ").appendValue(actual).appendText(")");
            }
        };
    }

    @Nonnull
    public static Matcher<Map<?, ?>> hasSameSizeAs(final @Nullable Object what) {
        return new TypeSafeMatcher<Map<?, ?>>(){

            public boolean matchesSafely(@Nullable Map<?, ?> item) {
                return this.getSizeOf(what) == 0 ? item == null || item.isEmpty() : item != null && this.getSizeOf(what) == item.size();
            }

            public void describeTo(Description description) {
                description.appendText("has size ").appendValue((Object)(what != null ? this.getSizeOf(what) : 0)).appendText(" (Same as: ").appendValue(what).appendText(")");
            }

            protected void describeMismatchSafely(@Nullable Map<?, ?> actual, @Nonnull Description description) {
                description.appendValue((Object)(actual != null ? actual.size() : 0)).appendText(" (Values: ").appendValue(actual).appendText(")");
            }

            private int getSizeOf(@Nullable Object what2) {
                int result;
                if (what2 == null) {
                    result = 0;
                } else if (what2 instanceof Collection) {
                    result = ((Collection)what2).size();
                } else if (what2 instanceof Map) {
                    result = ((Map)what2).size();
                } else if (what2 instanceof Object[]) {
                    result = ((Object[])what2).length;
                } else if (what2 instanceof CharSequence) {
                    result = ((CharSequence)what2).length();
                } else {
                    throw new IllegalArgumentException("Could not get size of " + what2 + ".");
                }
                return result;
            }
        };
    }

    private MapMatchers() {
    }
}

