/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.testing.io;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;

public class DummyUrlFactory {
    public static final String PROTOCOL_PREFIX = "dummyurl";

    private DummyUrlFactory() {
    }

    public static URL get(InputStream inputStream) throws MalformedURLException {
        return DummyUrlFactory.get(inputStream, "dummyurl:" + inputStream);
    }

    public static URL get(InputStream inputStream, String urlStr) throws MalformedURLException {
        return new URL(null, urlStr, new StreamHandler(inputStream));
    }

    public static URL get(String string, String encoding) throws MalformedURLException {
        return DummyUrlFactory.get(string, encoding, "dummyurl:" + string.hashCode());
    }

    public static URL get(String string, String encoding, String urlStr) throws MalformedURLException {
        return new URL(null, urlStr, new StreamHandler(string, encoding));
    }

    public static class Connection
    extends URLConnection {
        private InputStream _inputStream;
        private String _string;
        private String _encoding;

        protected Connection(URL u, InputStream inputStream) {
            super(u);
            this._inputStream = inputStream;
        }

        protected Connection(URL u, String string, String encoding) {
            super(u);
            this._string = string;
            this._encoding = encoding;
        }

        @Override
        public void connect() throws IOException {
        }

        @Override
        public InputStream getInputStream() throws IOException {
            InputStream result = this._inputStream != null ? this._inputStream : new ByteArrayInputStream(this._string.getBytes(this._encoding));
            return result;
        }

        @Override
        public String getContentEncoding() {
            String result = this._inputStream != null ? null : this._encoding;
            return result;
        }

        @Override
        public String getContentType() {
            String result = this._inputStream != null ? "application/binary" : "text/plain";
            return result;
        }

        @Override
        public int getContentLength() {
            int result = this._inputStream != null ? -1 : this._string.length();
            return result;
        }
    }

    public static class StreamHandler
    extends URLStreamHandler {
        private InputStream _inputstream;
        private String _string;
        private String _encoding;

        private StreamHandler(InputStream inputstream) {
            this._inputstream = inputstream;
        }

        private StreamHandler(String string, String encoding) {
            this._string = string;
            this._encoding = encoding;
        }

        @Override
        protected URLConnection openConnection(URL u) throws IOException {
            Connection result = this._inputstream != null ? new Connection(u, this._inputstream) : new Connection(u, this._string, this._encoding);
            return result;
        }
    }
}

