/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.testing;

import com.google.common.base.Predicate;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.echocat.jomon.runtime.util.Duration;
import org.hamcrest.BaseMatcher;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import org.hamcrest.core.IsNot;
import org.hamcrest.core.IsNull;

public class BaseMatchers {
    @Nonnull
    public static Matcher<Object> isSameAs(final @Nullable Object expected) {
        return new BaseMatcher<Object>(){

            public boolean matches(Object item) {
                return item == expected;
            }

            public void describeTo(@Nonnull Description description) {
                description.appendText("is same as ").appendValue(expected).appendText("#" + (expected != null ? Integer.valueOf(expected.hashCode()) : ""));
            }

            public void describeMismatch(@Nullable Object item, @Nonnull Description description) {
                description.appendText("was ").appendValue(item).appendText("#" + (item != null ? Integer.valueOf(item.hashCode()) : ""));
            }
        };
    }

    @Nonnull
    public static <T> Matcher<T> isEqualTo(@Nullable T expected) {
        return CoreMatchers.is(expected);
    }

    @Nonnull
    public static <T> Matcher<T> is(@Nullable T expected) {
        return BaseMatchers.isEqualTo(expected);
    }

    @Nonnull
    public static <T> Matcher<T> isNot(@Nullable T expected) {
        return BaseMatchers.not(BaseMatchers.is(expected));
    }

    @Nonnull
    public static <T> Matcher<T> isOneOf(@Nonnull T firstExpected, T ... others) {
        HashSet<T> them = new HashSet<T>();
        them.add(firstExpected);
        if (others != null) {
            them.addAll(Arrays.asList(others));
        }
        return BaseMatchers.isOneOf(them);
    }

    @Nonnull
    public static <T> Matcher<T> isOneOf(final @Nonnull Collection<T> them) {
        if (them.isEmpty()) {
            throw new IllegalArgumentException("There is no item provided.");
        }
        return new TypeSafeMatcher<T>(){

            public boolean matchesSafely(T t) {
                return them.contains(t);
            }

            public void describeTo(Description description) {
                description.appendText("is one of ").appendValue((Object)them);
            }
        };
    }

    @Nonnull
    public static <T> Matcher<T> equalTo(@Nullable T expected) {
        return BaseMatchers.isEqualTo(expected);
    }

    @Nonnull
    public static Matcher<Object> isNull() {
        return IsNull.nullValue();
    }

    @Nonnull
    public static Matcher<Object> isNotNull() {
        return IsNull.notNullValue();
    }

    @Nonnull
    public static Matcher<Boolean> isTrue() {
        return BaseMatchers.isEqualTo(true);
    }

    @Nonnull
    public static Matcher<Boolean> isFalse() {
        return BaseMatchers.isEqualTo(false);
    }

    @Nonnull
    public static <T> Matcher<T> not(Matcher<T> anotherMatcher) {
        return IsNot.not(anotherMatcher);
    }

    @Nonnull
    public static <T> Matcher<T> isEmpty() {
        return new TypeSafeMatcher<T>(){

            public boolean matchesSafely(Object item) {
                boolean result;
                if (item == null) {
                    result = true;
                } else if (item instanceof Collection) {
                    result = ((Collection)item).isEmpty();
                } else if (item instanceof Iterable) {
                    result = !((Iterable)item).iterator().hasNext();
                } else if (item instanceof Map) {
                    result = ((Map)item).isEmpty();
                } else if (item instanceof Object[]) {
                    result = ((Object[])item).length == 0;
                } else if (item instanceof CharSequence) {
                    result = ((CharSequence)item).length() == 0;
                } else {
                    throw new IllegalArgumentException("Could not handle an argument " + item);
                }
                return result;
            }

            public void describeTo(Description description) {
                description.appendValue((Object)"is empty");
            }
        };
    }

    @Nonnull
    public static Matcher<Object> hasNoItems() {
        return BaseMatchers.isEmpty();
    }

    @Nonnull
    public static Matcher<Object> hasItems() {
        return new BaseMatcher<Object>(){

            public boolean matches(Object item) {
                boolean result;
                if (item == null) {
                    result = false;
                } else if (item instanceof Collection) {
                    result = !((Collection)item).isEmpty();
                } else if (item instanceof Iterable) {
                    result = ((Iterable)item).iterator().hasNext();
                } else if (item instanceof Map) {
                    result = !((Map)item).isEmpty();
                } else if (item instanceof Object[]) {
                    result = ((Object[])item).length > 0;
                } else if (item instanceof CharSequence) {
                    result = ((CharSequence)item).length() > 0;
                } else {
                    throw new IllegalArgumentException("Could not handle an argument " + item);
                }
                return result;
            }

            public void describeTo(Description description) {
                description.appendValue((Object)"has items");
            }
        };
    }

    @Nonnull
    public static Matcher<Object> isNotEmpty() {
        return BaseMatchers.hasItems();
    }

    @Nonnull
    public static <T> Matcher<T> isGreaterThan(final @Nonnull T what) {
        return new TypeSafeMatcher<T>(){

            public boolean matchesSafely(T value) {
                boolean result = what instanceof Byte ? (Byte)value > (Byte)what : (what instanceof Character ? ((Character)value).charValue() > ((Character)what).charValue() : (what instanceof Short ? (Short)value > (Short)what : (what instanceof Integer ? (Integer)value > (Integer)what : (what instanceof Long ? (Long)value > (Long)what : (what instanceof Float ? ((Float)value).floatValue() > ((Float)what).floatValue() : (what instanceof Double ? (Double)value > (Double)what : (what instanceof Date ? ((Date)value).after((Date)what) : (what instanceof Duration ? ((Duration)value).isGreaterThan((Duration)what) : false))))))));
                return result;
            }

            public void describeTo(Description description) {
                description.appendText("is greater than ").appendValue(what);
            }
        };
    }

    @Nonnull
    public static <T> Matcher<T> isGreaterThanOrEqualTo(final @Nonnull T what) {
        return new TypeSafeMatcher<T>(){

            public boolean matchesSafely(T value) {
                boolean result = what instanceof Byte ? (Byte)value >= (Byte)what : (what instanceof Character ? ((Character)value).charValue() >= ((Character)what).charValue() : (what instanceof Short ? (Short)value >= (Short)what : (what instanceof Integer ? (Integer)value >= (Integer)what : (what instanceof Long ? (Long)value >= (Long)what : (what instanceof Float ? ((Float)value).floatValue() >= ((Float)what).floatValue() : (what instanceof Double ? (Double)value >= (Double)what : (what instanceof Date ? ((Date)value).after((Date)what) || value.equals(what) : (what instanceof Duration ? ((Duration)value).isGreaterThanOrEqualTo((Duration)what) : false))))))));
                return result;
            }

            public void describeTo(Description description) {
                description.appendText("is greater than or equal to ").appendValue(what);
            }
        };
    }

    @Nonnull
    public static <T> Matcher<T> isLessThan(final @Nonnull T what) {
        return new TypeSafeMatcher<T>(){

            public boolean matchesSafely(T value) {
                boolean result = what instanceof Byte ? (Byte)value < (Byte)what : (what instanceof Character ? ((Character)value).charValue() < ((Character)what).charValue() : (what instanceof Short ? (Short)value < (Short)what : (what instanceof Integer ? (Integer)value < (Integer)what : (what instanceof Long ? (Long)value < (Long)what : (what instanceof Float ? ((Float)value).floatValue() < ((Float)what).floatValue() : (what instanceof Double ? (Double)value < (Double)what : (what instanceof Date ? ((Date)value).before((Date)what) : (what instanceof Duration ? ((Duration)value).isLessThan((Duration)what) : false))))))));
                return result;
            }

            public void describeTo(Description description) {
                description.appendText("is less than ").appendValue(what);
            }
        };
    }

    @Nonnull
    public static <T> Matcher<T> isLessThanOrEqualTo(final @Nonnull T what) {
        return new TypeSafeMatcher<T>(){

            public boolean matchesSafely(T value) {
                boolean result = what instanceof Byte ? (Byte)value <= (Byte)what : (what instanceof Character ? ((Character)value).charValue() <= ((Character)what).charValue() : (what instanceof Short ? (Short)value <= (Short)what : (what instanceof Integer ? (Integer)value <= (Integer)what : (what instanceof Long ? (Long)value <= (Long)what : (what instanceof Float ? ((Float)value).floatValue() <= ((Float)what).floatValue() : (what instanceof Double ? (Double)value <= (Double)what : (what instanceof Date ? ((Date)value).before((Date)what) || value.equals(what) : (what instanceof Duration ? ((Duration)value).isLessThanOrEqualTo((Duration)what) : false))))))));
                return result;
            }

            public void describeTo(Description description) {
                description.appendText("is less than or equal to ").appendValue(what);
            }
        };
    }

    @Nonnull
    public static <T> Matcher<T> isInstanceOf(final @Nonnull Class<?> what) {
        return new BaseMatcher<T>(){

            public boolean matches(Object o) {
                return what.isInstance(o);
            }

            public void describeMismatch(@Nullable Object actual, @Nonnull Description description) {
                description.appendValue(actual != null ? actual.getClass().getName() : null);
            }

            public void describeTo(Description description) {
                description.appendText("is instance of ").appendValue((Object)what.getName());
            }
        };
    }

    @Nonnull
    public static <T> Matcher<T> hasSize(final @Nonnegative int size) {
        return new BaseMatcher<T>(){

            public boolean matches(@Nullable Object item) {
                boolean result = item != null ? size == BaseMatchers.getSizeOf(item) : false;
                return result;
            }

            public void describeTo(Description description) {
                description.appendText("has size of ").appendValue((Object)size);
            }

            public void describeMismatch(@Nullable Object actual, @Nonnull Description description) {
                BaseMatchers.handleDescribeSizeMismatch(actual, description);
            }
        };
    }

    @Nonnull
    public static <T> Matcher<T> hasSameSizeAs(final @Nullable Object what) {
        return new BaseMatcher<T>(){

            public boolean matches(@Nullable Object item) {
                int size;
                int n = size = what != null ? BaseMatchers.getSizeOf(what) : 0;
                return size == 0 ? item == null || BaseMatchers.getSizeOf(item) == 0 : item != null && BaseMatchers.getSizeOf(item) == size;
            }

            public void describeTo(Description description) {
                int size = what != null ? BaseMatchers.getSizeOf(what) : 0;
                description.appendText("has size of ").appendValue((Object)size);
            }

            public void describeMismatch(@Nullable Object actual, @Nonnull Description description) {
                BaseMatchers.handleDescribeSizeMismatch(actual, description);
            }
        };
    }

    @Nonnull
    public static <T> Matcher<T> applies(final @Nonnull Predicate<T> predicate) {
        return new BaseMatcher<T>(){

            public boolean matches(@Nullable Object item) {
                return predicate.apply(item);
            }

            public void describeTo(Description description) {
                description.appendText("applies ").appendValue((Object)predicate);
            }
        };
    }

    @Nonnegative
    protected static int getSizeOf(@Nullable Object what) {
        int result;
        if (what == null) {
            result = 0;
        } else if (what instanceof Collection) {
            result = ((Collection)what).size();
        } else if (what instanceof Map) {
            result = ((Map)what).size();
        } else if (what instanceof Object[]) {
            result = ((Object[])what).length;
        } else if (what instanceof CharSequence) {
            result = ((CharSequence)what).length();
        } else {
            throw new IllegalArgumentException("Could not get size of " + what + ".");
        }
        return result;
    }

    protected static void handleDescribeSizeMismatch(@Nullable Object actual, @Nonnull Description description) {
        description.appendText("was ");
        if (actual == null) {
            description.appendValue(null);
        } else {
            description.appendValue((Object)BaseMatchers.getSizeOf(actual));
            if (actual instanceof Map || actual instanceof Collection) {
                description.appendText(" (Values: ").appendValue(actual).appendText(")");
            } else if (actual instanceof Object[]) {
                description.appendText(" (Values: ").appendValue((Object)Arrays.toString((Object[])actual)).appendText(")");
            } else if (actual instanceof CharSequence) {
                description.appendText(" (Content: ").appendValue(actual).appendText(")");
            }
        }
    }

    private BaseMatchers() {
    }
}

