/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.testing.concurrent;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;

public class ParallelTestRunner {
    private final List<Worker> _workers;

    public ParallelTestRunner(List<Worker> workers) {
        this._workers = workers;
    }

    public static void run(@Nonnull List<Worker> workers) {
        new ParallelTestRunner(workers).run();
    }

    public void run() {
        ArrayList<WorkerThread> threads = new ArrayList<WorkerThread>(this._workers.size());
        int i = 1;
        for (Worker worker : this._workers) {
            WorkerThread thread = new WorkerThread("WorkerThread #" + i, worker);
            ++i;
            threads.add(thread);
            thread.start();
        }
        for (WorkerThread thread : threads) {
            Throwable e;
            try {
                thread.join();
            }
            catch (InterruptedException ignored) {
                this.interrupt(threads);
            }
            if ((e = thread.getThrowable()) == null) continue;
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            if (e instanceof Error) {
                throw (Error)e;
            }
            throw new RuntimeException(e);
        }
    }

    private void interrupt(List<WorkerThread> threads) {
        for (WorkerThread thread : threads) {
            thread.interrupt();
        }
    }

    private static class WorkerThread
    extends Thread {
        private final Worker _worker;
        private Throwable _throwable;

        private WorkerThread(String name, Worker worker) {
            super(name);
            this._worker = worker;
        }

        @Override
        public void run() {
            try {
                this._worker.run();
            }
            catch (Throwable t) {
                this._throwable = t;
            }
        }

        public Throwable getThrowable() {
            return this._throwable;
        }
    }

    public static interface Worker {
        public void run() throws Exception;
    }
}

