/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.locela.api.java.annotations;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.echocat.jomon.runtime.CollectionUtils;
import org.echocat.locela.api.java.annotations.Annotation;
import org.echocat.locela.api.java.annotations.AnnotationFormatter;
import org.echocat.locela.api.java.annotations.CommentAnnotation;

@ThreadSafe
public class AnnotationsFormatter {
    private static final AnnotationsFormatter INSTANCE = new AnnotationsFormatter();
    @Nonnull
    private final AnnotationFormatter _annotationFormatter;

    @Nonnull
    public static AnnotationsFormatter annotationsFormatter() {
        return INSTANCE;
    }

    public AnnotationsFormatter() {
        this(null);
    }

    public AnnotationsFormatter(@Nullable AnnotationFormatter annotationFormatter) {
        this._annotationFormatter = annotationFormatter != null ? annotationFormatter : AnnotationFormatter.annotationFormatter();
    }

    @Nonnull
    public String format(Annotation ... annotations) {
        return this.format(CollectionUtils.asList((Object[])annotations));
    }

    @Nonnull
    public String format(@Nullable Iterable<Annotation> annotations) {
        StringBuilder sb = new StringBuilder();
        for (Annotation annotation : annotations) {
            if (annotation instanceof CommentAnnotation) {
                String content = ((CommentAnnotation)annotation).getContent().trim();
                if (content.isEmpty()) continue;
                sb.append(content).append('\n');
                continue;
            }
            sb.append('@').append(this.annotationFormatter().format(annotation)).append('\n');
        }
        return sb.toString();
    }

    @Nonnull
    protected AnnotationFormatter annotationFormatter() {
        return this._annotationFormatter;
    }
}

