/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.locela.api.java.messages;

import java.io.IOException;
import java.util.Locale;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.echocat.jomon.cache.Cache;
import org.echocat.jomon.cache.LfuCache;
import org.echocat.jomon.cache.management.CacheDefinition;
import org.echocat.jomon.cache.management.CacheProvider;
import org.echocat.jomon.cache.management.DefaultCacheDefinition;
import org.echocat.jomon.runtime.util.ValueProducer;
import org.echocat.locela.api.java.messages.FileAccessor;
import org.echocat.locela.api.java.messages.Messages;
import org.echocat.locela.api.java.messages.MessagesProvider;
import org.echocat.locela.api.java.messages.MessagesProviderSupport;

public class CachingMessagesProvider
extends MessagesProviderSupport {
    @Nonnull
    private final MessagesProvider _delegate;
    @Nonnull
    private final Cache<CacheKey, Messages> _cache;
    @Nonnull
    private final ValueProducer<CacheKey, Messages> _valueProducer = new ValueProducer<CacheKey, Messages>(){

        @Nullable
        public Messages produce(@Nullable CacheKey key) throws Exception {
            return CachingMessagesProvider.this.delegate().provideBy(key.getLocale(), key.getAccessor(), key.getBaseFile());
        }
    };

    public CachingMessagesProvider(@Nonnull MessagesProvider delegate, @Nonnull long capacity) {
        this._delegate = delegate;
        this._cache = this.createCache(capacity);
    }

    public CachingMessagesProvider(@Nonnull MessagesProvider delegate, @Nonnull CacheProvider cacheProvider) {
        this._delegate = delegate;
        this._cache = this.createCache(cacheProvider);
    }

    @Override
    @Nullable
    public Messages provideBy(@Nullable Locale locale, @Nonnull FileAccessor accessor, @Nonnull String baseFile) throws IOException {
        CacheKey key = new CacheKey(locale, accessor, baseFile);
        return (Messages)this.cache().get((Object)key, this.valueProducer());
    }

    @Nonnull
    protected Cache<CacheKey, Messages> createCache(@Nonnegative long capacity) {
        LfuCache cache = new LfuCache(CacheKey.class, Messages.class);
        cache.setCapacity(Long.valueOf(capacity));
        return cache;
    }

    @Nonnull
    protected Cache<CacheKey, Messages> createCache(@Nonnull CacheProvider with) {
        return with.provide(CachingMessagesProvider.class, "messages", (CacheDefinition)((DefaultCacheDefinition)DefaultCacheDefinition.lfuCache(CacheKey.class, Messages.class).withCapacity(100L)).withMaximumLifetime("1h"));
    }

    @Nonnull
    protected Cache<CacheKey, Messages> cache() {
        return this._cache;
    }

    @Nonnull
    protected MessagesProvider delegate() {
        return this._delegate;
    }

    @Nonnull
    protected ValueProducer<CacheKey, Messages> valueProducer() {
        return this._valueProducer;
    }

    protected static class CacheKey {
        @Nullable
        private final Locale _locale;
        @Nonnull
        private final FileAccessor _accessor;
        @Nonnull
        private final String _baseFile;

        public CacheKey(@Nullable Locale locale, @Nonnull FileAccessor accessor, @Nonnull String baseFile) {
            this._locale = locale;
            this._accessor = accessor;
            this._baseFile = baseFile;
        }

        @Nullable
        public Locale getLocale() {
            return this._locale;
        }

        @Nonnull
        public FileAccessor getAccessor() {
            return this._accessor;
        }

        @Nonnull
        public String getBaseFile() {
            return this._baseFile;
        }

        public boolean equals(Object o) {
            boolean result;
            if (this == o) {
                result = true;
            } else if (o == null || !(o instanceof CacheKey)) {
                result = false;
            } else {
                Locale locale;
                CacheKey that = (CacheKey)o;
                result = this.getBaseFile().equals(that.getBaseFile()) ? (((locale = this.getLocale()) != null ? locale.equals(that.getLocale()) : that.getLocale() == null) ? this.getAccessor().equals(that.getAccessor()) : false) : false;
            }
            return result;
        }

        public int hashCode() {
            Locale locale = this.getLocale();
            return 0 + (locale != null ? locale.hashCode() : 0) + this.getAccessor().hashCode() + this.getBaseFile().hashCode();
        }
    }
}

