/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.locela.api.java.messages;

import java.io.IOException;
import java.io.Writer;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.echocat.jomon.runtime.util.ProducingType;
import org.echocat.jomon.runtime.util.Value;
import org.echocat.jomon.runtime.util.ValueProducer;
import org.echocat.locela.api.java.format.Formatter;
import org.echocat.locela.api.java.format.FormatterFactory;
import org.echocat.locela.api.java.format.MessageFormatterFactory;
import org.echocat.locela.api.java.messages.MessageSupport;

public abstract class FormattingMessageSupport
extends MessageSupport {
    protected static final Locale DEFAULT_LOCALE = Locale.US;
    @Nonnull
    private final FormatterFactory<?> _formatterFactory;
    @Nonnull
    private final ValueProducer<Boolean, Formatter> _formatterProducer;
    @Nonnull
    private final Value.Lazy<Boolean, Formatter> _formatter;

    public FormattingMessageSupport(@Nullable FormatterFactory<?> formatterFactory) {
        this._formatterFactory = formatterFactory != null ? formatterFactory : MessageFormatterFactory.messageFormatterFactory();
        this._formatterProducer = new FormatterProducer();
        this._formatter = new Value.Lazy((Object)Boolean.TRUE, this._formatterProducer, ProducingType.nonBlocking);
    }

    @Override
    public void format(@Nullable Object value, @Nonnull Writer to) throws IOException {
        this.formatter().format(value, to);
    }

    @Nonnull
    protected Formatter formatter() {
        return (Formatter)this._formatter.getValue();
    }

    protected class FormatterProducer
    implements ValueProducer<Boolean, Formatter> {
        protected FormatterProducer() {
        }

        @Nullable
        public Formatter produce(@Nullable Boolean key) throws Exception {
            Locale locale = FormattingMessageSupport.this.getLocale();
            return FormattingMessageSupport.this._formatterFactory.createBy(locale != null ? locale : DEFAULT_LOCALE, FormattingMessageSupport.this.get(), FormattingMessageSupport.this._formatterFactory);
        }
    }
}

