/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.locela.api.java.properties;

import java.io.IOException;
import java.io.Reader;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.echocat.locela.api.java.properties.Line;
import org.echocat.locela.api.java.properties.PropertiesLineReader;

@ThreadSafe
public class StandardPropertiesLineReader
implements PropertiesLineReader {
    @Nonnull
    private final Reader _delegate;
    @Nonnull
    private final char[] _buffer;
    @Nonnegative
    private int _bufferPosition;
    @Nonnegative
    private int _bufferSize;

    public StandardPropertiesLineReader(@Nonnull Reader delegate) {
        this(delegate, 4096);
    }

    public StandardPropertiesLineReader(@Nonnull Reader delegate, @Nonnegative int bufferSize) {
        this._delegate = delegate;
        this._buffer = new char[bufferSize];
    }

    @Override
    @Nullable
    public Line read() throws IOException {
        boolean atBeginOfLine = true;
        Line line = null;
        Character c = this.next();
        int lasLengthWithCharactersAtTheEnd = 0;
        StringBuilder sb = new StringBuilder();
        boolean commentLine = false;
        boolean lastWasEscape = false;
        boolean continuedLine = false;
        while (c != null && line == null) {
            if (c.charValue() == ' ' || c.charValue() == '\t') {
                if (lastWasEscape) {
                    sb.append('\\');
                    lasLengthWithCharactersAtTheEnd = sb.length();
                    lastWasEscape = false;
                }
                if (!atBeginOfLine) {
                    sb.append(c);
                }
            } else if (c.charValue() == '\r' || c.charValue() == '\n') {
                if (lastWasEscape) {
                    atBeginOfLine = true;
                    continuedLine = true;
                } else {
                    sb.setLength(lasLengthWithCharactersAtTheEnd);
                    line = this.toLine(sb, commentLine);
                }
                lastWasEscape = false;
            } else if (atBeginOfLine) {
                if (!(c.charValue() != '!' && c.charValue() != '#' || continuedLine)) {
                    commentLine = true;
                } else {
                    sb.append(c);
                    lasLengthWithCharactersAtTheEnd = sb.length();
                }
                atBeginOfLine = false;
                continuedLine = false;
            } else if (c.charValue() == '\\') {
                if (lastWasEscape) {
                    sb.append(c);
                    lasLengthWithCharactersAtTheEnd = sb.length();
                    lastWasEscape = false;
                } else {
                    lastWasEscape = true;
                }
            } else {
                if (lastWasEscape) {
                    sb.append('\\');
                    lastWasEscape = false;
                }
                sb.append(c);
                lasLengthWithCharactersAtTheEnd = sb.length();
            }
            if (line != null) continue;
            c = this.next();
        }
        if (line == null) {
            if (lastWasEscape) {
                sb.append('\\');
            }
            sb.setLength(lasLengthWithCharactersAtTheEnd);
            if (sb.length() > 0) {
                line = this.toLine(sb, commentLine);
            }
        }
        return line;
    }

    @Nonnull
    protected Line toLine(@Nonnull StringBuilder sb, boolean commentLine) {
        Line.LineSupport result = commentLine ? new Line.CommentLine(sb.toString()) : (sb.length() > 0 ? new Line.PropertyLine(sb.toString()) : new Line.EmptyLine());
        return result;
    }

    @Nullable
    protected Character next() throws IOException {
        while (this._bufferPosition >= this._bufferSize && this._bufferSize > -1) {
            this._bufferSize = this._delegate.read(this._buffer);
            this._bufferPosition = 0;
        }
        return this._bufferSize > -1 ? Character.valueOf(this._buffer[this._bufferPosition++]) : null;
    }

    @Override
    public void close() throws IOException {
        this._delegate.close();
    }
}

