/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.locela.api.java.annotations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.echocat.jomon.runtime.CollectionUtils;
import org.echocat.locela.api.java.annotations.Annotation;
import org.echocat.locela.api.java.annotations.AnnotationContainer;
import org.echocat.locela.api.java.support.IterationUtils;

public abstract class AnnotationContainerSupport
implements AnnotationContainer {
    @Nonnull
    private final List<Annotation> _annotations = new ArrayList<Annotation>();
    @Nonnull
    private final IterationUtils.RemoveHandler<Annotation> _removeHandler = new IterationUtils.RemoveHandler<Annotation>(){

        @Override
        public void remove(@Nonnull Annotation what) {
            AnnotationContainerSupport.this.removeAnnotation(what);
        }
    };

    @Nonnull
    public List<Annotation> annotations() {
        return this._annotations;
    }

    @Override
    @Nonnull
    public <T extends Annotation> Iterable<T> annotations(final @Nonnull Class<? extends T> ofType) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                ArrayList result = new ArrayList();
                for (Annotation annotation : AnnotationContainerSupport.this.annotations()) {
                    if (!ofType.isInstance(annotation)) continue;
                    result.add(ofType.cast(annotation));
                }
                return IterationUtils.toIterator(AnnotationContainerSupport.this._removeHandler, result);
            }
        };
    }

    protected void addAnnotations(@Nullable Iterable<? extends Annotation> annotations) {
        CollectionUtils.addAll((Collection)this.annotations(), annotations);
    }

    protected void addAnnotations(Annotation ... annotations) {
        CollectionUtils.addAll((Collection)this.annotations(), (Object[])annotations);
    }

    @Override
    public void addAnnotation(@Nonnull Annotation annotation) {
        if (!this.annotations().contains(annotation)) {
            this.annotations().add(annotation);
        }
    }

    @Override
    public void removeAnnotation(@Nonnull Annotation annotation) {
        this.annotations().remove(annotation);
    }

    @Override
    public void removeAnnotations(@Nonnull Class<? extends Annotation> ofType) {
        Iterator<? extends Annotation> i = this.annotations(ofType).iterator();
        while (i.hasNext()) {
            i.next();
            i.remove();
        }
    }
}

