/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.locela.api.java.messages;

import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import org.echocat.locela.api.java.messages.DummyMessage;
import org.echocat.locela.api.java.messages.Message;
import org.echocat.locela.api.java.messages.Messages;

public abstract class MessagesSupport
implements Messages {
    @Override
    @Nonnull
    public Message get(@Nonnull String id) {
        Message message = this.find(id);
        return message != null ? message : this.dummyMessageFor(id);
    }

    @Nonnull
    protected DummyMessage dummyMessageFor(@Nonnull String id) {
        return new DummyMessage(null, id);
    }

    public boolean equals(Object o) {
        boolean result;
        if (this == o) {
            result = true;
        } else if (o == null || !(o instanceof Messages)) {
            result = false;
        } else {
            Set<String> thatIds;
            Messages that = (Messages)o;
            Set<String> thisIds = this.getIdsOf(this);
            if (thisIds.equals(thatIds = this.getIdsOf(that))) {
                result = true;
                for (Message thisMessage : this) {
                    Message thatMessage;
                    if (thisMessage.equals(thatMessage = that.get((String)thisMessage.getId()))) continue;
                    result = false;
                    break;
                }
            } else {
                result = false;
            }
        }
        return result;
    }

    @Nonnull
    protected Set<String> getIdsOf(@Nonnull Iterable<Message> messages) {
        HashSet<String> result = new HashSet<String>();
        for (Message message : messages) {
            result.add((String)message.getId());
        }
        return result;
    }

    public int hashCode() {
        int result = 0;
        for (String id : this.getIdsOf(this)) {
            result = 31 * result + this.get(id).hashCode();
        }
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        boolean firstMessage = true;
        for (Message message : this) {
            if (firstMessage) {
                sb.append('\n');
                firstMessage = false;
            }
            sb.append("    ").append(message).append('\n');
        }
        sb.append('}');
        return sb.toString();
    }
}

