/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.locela.api.java.annotations;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.ServiceLoader;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.echocat.jomon.runtime.CollectionUtils;
import org.echocat.locela.api.java.annotations.Annotation;

@ThreadSafe
public class StandardAnnotationFactoryProvider
implements Annotation.Factory.Provider {
    private static final Annotation.Factory.Provider INSTANCE = new StandardAnnotationFactoryProvider(StandardAnnotationFactoryProvider.findDefaultFactories());
    @Nonnull
    private final Map<String, Annotation.Factory<? extends Annotation>> _idToFactory = new LinkedHashMap<String, Annotation.Factory<? extends Annotation>>();
    @Nonnull
    private final Map<Class<? extends Annotation>, Annotation.Factory<? extends Annotation>> _typeToFactory = new LinkedHashMap<Class<? extends Annotation>, Annotation.Factory<? extends Annotation>>();

    @Nonnull
    public static Annotation.Factory.Provider annotaionFactoryProvider() {
        return INSTANCE;
    }

    public StandardAnnotationFactoryProvider(Annotation.Factory<? extends Annotation> ... providers) {
        this(CollectionUtils.asList((Object[])providers));
    }

    public StandardAnnotationFactoryProvider(@Nullable Iterable<Annotation.Factory<? extends Annotation>> providers) {
        if (providers != null) {
            for (Annotation.Factory<? extends Annotation> provider : providers) {
                this._idToFactory.put(provider.getId(), provider);
                this._typeToFactory.put(provider.getResponsibleFor(), provider);
            }
        }
    }

    @Override
    @Nonnull
    public <T extends Annotation> Annotation.Factory<T> provideBy(@Nonnull Class<T> type) throws Annotation.Factory.Provider.UnknownAnnotationException {
        Annotation.Factory<? extends Annotation> result = this._typeToFactory.get(type);
        if (result == null) {
            throw new Annotation.Factory.Provider.UnknownAnnotationException("Could not find any factory that could handle annotation of type '" + type.getName() + "'.");
        }
        return result;
    }

    @Override
    @Nonnull
    public Annotation.Factory<? extends Annotation> provideBy(@Nonnull String id) throws Annotation.Factory.Provider.UnknownAnnotationException {
        Annotation.Factory<? extends Annotation> result = this._idToFactory.get(id);
        if (result == null) {
            throw new Annotation.Factory.Provider.UnknownAnnotationException("Could not find any factory that could handle annotation of id '" + id + "'.");
        }
        return result;
    }

    @Override
    public Iterator<Annotation.Factory<? extends Annotation>> iterator() {
        return CollectionUtils.asImmutableSet(this._idToFactory.values()).iterator();
    }

    @Nonnull
    protected static Iterable<Annotation.Factory<? extends Annotation>> findDefaultFactories() {
        return ServiceLoader.load(Annotation.Factory.class);
    }
}

