/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.locela.api.java.format;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.lang3.StringUtils;
import org.echocat.jomon.runtime.CollectionUtils;
import org.echocat.jomon.runtime.util.Value;
import org.echocat.locela.api.java.format.Formatter;
import org.echocat.locela.api.java.format.FormatterFactory;
import org.echocat.locela.api.java.format.FormatterSupport;
import org.echocat.locela.api.java.format.MessageFormatterFactory;

@ThreadSafe
public class MessageFormatter
extends FormatterSupport
implements Iterable<Formatter> {
    protected static final ThreadLocal<Value<Object>> CALLED_VALUE = new ThreadLocal();
    @Nonnull
    private final List<Formatter> _subFormatter;

    protected static void formatInternal(@Nonnull Locale locale, @Nonnull String pattern, @Nullable Object value, @Nonnull Writer to) throws IOException {
        MessageFormatterFactory.messageFormatterFactory().createBy(locale, pattern).format(value, to);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nonnull
    protected static String formatInternal(@Nonnull Locale locale, @Nonnull String pattern, @Nullable Object value) {
        try (StringWriter writer = new StringWriter();){
            MessageFormatterFactory.messageFormatterFactory().createBy(locale, pattern).format(value, writer);
            String string = writer.toString();
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static void format(@Nonnull Locale locale, @Nonnull String pattern, @Nonnull Writer to, Object ... values) throws IOException {
        MessageFormatter.formatInternal(locale, pattern, values, to);
    }

    @Nonnull
    public static String format(@Nonnull Locale locale, @Nonnull String pattern, Object ... values) {
        return MessageFormatter.formatInternal(locale, pattern, values);
    }

    public static void format(@Nonnull Locale locale, @Nonnull String pattern, @Nonnull Writer to, @Nullable Iterable<?> values) throws IOException {
        MessageFormatter.formatInternal(locale, pattern, values, to);
    }

    @Nonnull
    public static String format(@Nonnull Locale locale, @Nonnull String pattern, @Nullable Iterable<?> values) {
        return MessageFormatter.formatInternal(locale, pattern, values);
    }

    public static void format(@Nonnull Locale locale, @Nonnull String pattern, @Nonnull Writer to, @Nullable Map<?, ?> values) throws IOException {
        MessageFormatter.formatInternal(locale, pattern, values, to);
    }

    @Nonnull
    public static String format(@Nonnull Locale locale, @Nonnull String pattern, @Nullable Map<?, ?> values) {
        return MessageFormatter.formatInternal(locale, pattern, values);
    }

    public MessageFormatter(@Nonnull Locale locale, @Nullable String pattern) throws IllegalArgumentException {
        this(locale, pattern, MessageFormatterFactory.messageFormatterFactory());
    }

    public MessageFormatter(@Nonnull Locale locale, @Nullable String pattern, FormatterFactory<?> ... factories) throws IllegalArgumentException {
        this(locale, pattern, new MessageFormatterFactory(factories));
    }

    protected MessageFormatter(@Nonnull Locale locale, @Nullable String pattern, @Nonnull MessageFormatterFactory root) throws IllegalArgumentException {
        super(locale);
        this._subFormatter = this.parseSubFormatters(locale, pattern, root);
    }

    protected MessageFormatter(@Nonnull Locale locale, @Nullable List<Formatter> subFormatter) throws IllegalArgumentException {
        super(locale);
        this._subFormatter = subFormatter != null ? CollectionUtils.asImmutableList(subFormatter) : Collections.emptyList();
    }

    @Override
    public Iterator<Formatter> iterator() {
        return this.getSubFormatter().iterator();
    }

    @Nonnull
    public List<Formatter> getSubFormatter() {
        return this._subFormatter;
    }

    @Nonnull
    protected List<Formatter> parseSubFormatters(@Nonnull Locale locale, @Nullable String pattern, @Nonnull MessageFormatterFactory root) throws IllegalArgumentException {
        ArrayList<Formatter> result = new ArrayList<Formatter>();
        if (pattern != null) {
            boolean inEscape = false;
            int depth = 0;
            char[] chars = pattern.toCharArray();
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < chars.length; ++i) {
                char c = chars[i];
                if (c == '\'') {
                    if (i + 1 < chars.length && chars[i + 1] == '\'') {
                        sb.append('\'');
                        ++i;
                        continue;
                    }
                    inEscape = !inEscape;
                    continue;
                }
                if (inEscape) {
                    sb.append(c);
                    continue;
                }
                if (c == '{') {
                    if (depth == 0) {
                        result.add(new StaticFormatter(locale, sb.toString()));
                        sb.setLength(0);
                    } else {
                        sb.append('{');
                    }
                    ++depth;
                    continue;
                }
                if (c == '}') {
                    if (--depth == 0) {
                        result.add(this.parseSubFormatter(locale, sb.toString(), root));
                        sb.setLength(0);
                        continue;
                    }
                    sb.append('}');
                    continue;
                }
                sb.append(c);
            }
            if (depth > 0) {
                throw new IllegalArgumentException("Unmatched braces in the pattern.");
            }
            if (inEscape) {
                sb.append('\'');
            }
            if (sb.length() > 0) {
                result.add(new StaticFormatter(locale, sb.toString()));
            }
        }
        return CollectionUtils.asImmutableList(result);
    }

    @Nonnull
    protected Formatter parseSubFormatter(@Nonnull Locale locale, @Nonnull String pattern, @Nonnull MessageFormatterFactory root) throws IllegalArgumentException {
        String parameter = null;
        String formatterId = null;
        String formatterPattern = null;
        char[] chars = pattern.toCharArray();
        StringBuilder sb = new StringBuilder();
        for (char c : chars) {
            if (c == ',') {
                if (parameter == null) {
                    parameter = sb.toString();
                    sb.setLength(0);
                    continue;
                }
                if (formatterId == null) {
                    formatterId = sb.toString();
                    sb.setLength(0);
                    continue;
                }
                sb.append(c);
                continue;
            }
            sb.append(c);
        }
        if (parameter == null) {
            parameter = sb.toString();
        } else if (formatterId == null) {
            formatterId = sb.toString();
        } else {
            formatterPattern = sb.toString();
        }
        return this.getSubFormatterFor(locale, parameter, formatterId, formatterPattern, root);
    }

    @Nonnull
    protected Formatter getSubFormatterFor(@Nonnull Locale locale, @Nonnull String parameter, @Nullable String id, @Nullable String pattern, @Nonnull MessageFormatterFactory root) throws IllegalArgumentException {
        PassThruFormatter formatter;
        if (id != null) {
            FormatterFactory<MessageFormatter> factory = root.getFactoryBy(id);
            formatter = factory.createBy(locale, pattern, root);
        } else {
            formatter = new PassThruFormatter(locale);
        }
        return new ParameterAwareFormatter(locale, parameter, formatter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void format(final @Nullable Object value, @Nonnull Writer to) throws IOException {
        Object targetValue;
        Value<Object> calledValue = CALLED_VALUE.get();
        if (calledValue == null) {
            CALLED_VALUE.set(new Value<Object>(){

                @Nonnull
                public Object getValue() {
                    return value;
                }
            });
            targetValue = value;
        } else {
            targetValue = calledValue.getValue();
        }
        try {
            for (Formatter formatter : this) {
                formatter.format(targetValue, to);
            }
        }
        finally {
            if (calledValue == null) {
                CALLED_VALUE.remove();
            }
        }
    }

    public void format(@Nonnull Writer to, Object ... values) throws IOException {
        this.format((Object)values, to);
    }

    @Nonnull
    public String format(Object ... values) {
        return this.formatInternal(values);
    }

    public void format(@Nonnull Writer to, @Nullable Iterable<?> values) throws IOException {
        this.format(values, to);
    }

    @Nonnull
    public String format(@Nullable Iterable<?> values) {
        return this.formatInternal(values);
    }

    public void format(@Nonnull Writer to, @Nullable Map<?, ?> values) throws IOException {
        this.format(values, to);
    }

    @Nonnull
    public String format(@Nullable Map<?, ?> values) {
        return this.formatInternal(values);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nonnull
    protected String formatInternal(@Nullable Object value) {
        try (StringWriter writer = new StringWriter();){
            this.format(value, writer);
            String string = writer.toString();
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Formatter formatter : this) {
            sb.append(formatter);
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        boolean result;
        if (this == o) {
            result = true;
        } else if (o == null || !(o instanceof MessageFormatter)) {
            result = false;
        } else {
            MessageFormatter that = (MessageFormatter)o;
            result = this.getSubFormatter().equals(that.getSubFormatter());
        }
        return result;
    }

    public int hashCode() {
        return this.getSubFormatter().hashCode();
    }

    @ThreadSafe
    protected static class StaticFormatter
    extends FormatterSupport {
        @Nonnull
        private final String _content;

        public StaticFormatter(@Nonnull Locale locale, @Nonnull String content) {
            super(locale);
            this._content = content;
        }

        @Override
        public void format(@Nullable Object value, @Nonnull Writer to) throws IOException {
            to.write(this.getContent());
        }

        @Nonnull
        public String getContent() {
            return this._content;
        }

        public String toString() {
            return this.getContent();
        }

        public boolean equals(Object o) {
            boolean result;
            if (this == o) {
                result = true;
            } else if (o == null || this.getClass() != o.getClass()) {
                result = false;
            } else {
                StaticFormatter that = (StaticFormatter)o;
                result = this._content.equals(that._content);
            }
            return result;
        }

        public int hashCode() {
            return this._content.hashCode();
        }
    }

    @ThreadSafe
    protected static class ParameterAwareFormatter
    extends FormatterSupport {
        @Nonnull
        private final String _parameter;
        @Nullable
        private final Integer _parameterAsInteger;
        @Nonnull
        private final Formatter _delegate;

        public ParameterAwareFormatter(@Nonnull Locale locale, @Nonnull String parameter, @Nonnull Formatter delegate) {
            super(locale);
            this._parameter = parameter;
            this._parameterAsInteger = this.tryGetAsInteger(parameter);
            this._delegate = delegate;
        }

        @Nullable
        protected Integer tryGetAsInteger(@Nonnull String parameter) {
            Integer result;
            try {
                result = Integer.parseInt(parameter);
            }
            catch (NumberFormatException ignored) {
                result = null;
            }
            return result;
        }

        @Override
        public void format(@Nullable Object value, @Nonnull Writer to) throws IOException {
            this._delegate.format(this.selectValueFrom(value), to);
        }

        @Nullable
        protected Object selectValueFrom(@Nullable Object input) {
            Object result;
            if (input == null) {
                result = null;
            } else if (input instanceof Map) {
                Map map = (Map)input;
                result = map.get(this._parameter);
                if (result == null && this._parameterAsInteger != null) {
                    result = map.get(this._parameterAsInteger);
                }
            } else {
                List list;
                Object[] array;
                result = input instanceof Object[] && this._parameterAsInteger != null ? ((array = (Object[])input).length > this._parameterAsInteger ? array[this._parameterAsInteger] : null) : (input instanceof List && this._parameterAsInteger != null ? ((list = (List)input).size() > this._parameterAsInteger ? list.get(this._parameterAsInteger) : null) : ("0".equals(this._parameter) ? input : null));
            }
            return result;
        }

        public String toString() {
            String delegateAsString;
            StringBuilder sb = new StringBuilder();
            sb.append('{').append(this._parameter);
            String string = delegateAsString = this._delegate instanceof PassThruFormatter ? null : this._delegate.toString();
            if (!StringUtils.isEmpty((CharSequence)delegateAsString)) {
                sb.append(',').append(delegateAsString);
            }
            sb.append('}');
            return sb.toString();
        }

        public boolean equals(Object o) {
            boolean result;
            if (this == o) {
                result = true;
            } else if (o == null || this.getClass() != o.getClass()) {
                result = false;
            } else {
                ParameterAwareFormatter that = (ParameterAwareFormatter)o;
                result = this._delegate.equals(that._delegate) && this._parameter.equals(that._parameter);
            }
            return result;
        }

        public int hashCode() {
            return 31 * this._parameter.hashCode() + this._delegate.hashCode();
        }
    }

    @ThreadSafe
    protected static class PassThruFormatter
    extends FormatterSupport {
        public PassThruFormatter(@Nonnull Locale locale) {
            super(locale);
        }

        @Override
        public void format(@Nullable Object value, @Nonnull Writer to) throws IOException {
            if (value != null) {
                to.write(value.toString());
            }
        }

        public boolean equals(Object o) {
            boolean result = this == o ? true : o != null && this.getClass() == o.getClass();
            return result;
        }

        public int hashCode() {
            return 0;
        }
    }
}

