/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.locela.api.java.support;

import com.google.common.base.Predicate;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.echocat.jomon.runtime.iterators.ChainedIterator;
import org.echocat.jomon.runtime.iterators.IteratorUtils;
import org.echocat.locela.api.java.messages.Message;
import org.echocat.locela.api.java.messages.Messages;

public class FilterDuplicatesMessagesIterator
extends ChainedIterator<Messages, Message> {
    @Nonnull
    private final Predicate<Message> _predicate = new FilterDuplicateIds();

    public FilterDuplicatesMessagesIterator(@Nonnull Iterable<Messages> inputs) {
        super(inputs);
    }

    @Nullable
    protected Iterator<Message> nextIterator(@Nullable Messages input) {
        return IteratorUtils.filter(input.iterator(), this._predicate);
    }

    protected static class FilterDuplicateIds
    implements Predicate<Message> {
        @Nonnull
        private final Set<String> _alreadyAllowedIds = new HashSet<String>();

        protected FilterDuplicateIds() {
        }

        public boolean apply(@Nonnull Message input) {
            String id = (String)input.getId();
            return this._alreadyAllowedIds.add(id);
        }
    }
}

