/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.locela.api.java.format;

import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.echocat.locela.api.java.format.ChoiceFormatter;
import org.echocat.locela.api.java.format.DateFormatter;
import org.echocat.locela.api.java.format.DateTimeFormatter;
import org.echocat.locela.api.java.format.FormatterFactory;
import org.echocat.locela.api.java.format.MessageFormatter;
import org.echocat.locela.api.java.format.NumberFormatter;
import org.echocat.locela.api.java.format.TimeFormatter;
import org.echocat.locela.api.java.support.CollectionUtils;

@ThreadSafe
public class MessageFormatterFactory
implements FormatterFactory<MessageFormatter> {
    private static final MessageFormatterFactory INSTANCE = new MessageFormatterFactory(ChoiceFormatter.choiceFormatterFactory(), DateFormatter.dateFormatterFactory(), DateTimeFormatter.dateTimeFormatterFactory(), NumberFormatter.numberFormatterFactory(), TimeFormatter.timeFormatterFactory());
    @Nonnull
    private final Map<String, FormatterFactory<?>> _idToFactory;

    @Nonnull
    public static MessageFormatterFactory messageFormatterFactory() {
        return INSTANCE;
    }

    public MessageFormatterFactory(@Nullable Iterable<FormatterFactory<?>> factories) {
        this._idToFactory = this.toIdToFactory(factories);
    }

    public MessageFormatterFactory(FormatterFactory<?> ... factories) {
        this(CollectionUtils.asList(factories));
    }

    @Nonnull
    protected Map<String, FormatterFactory<?>> toIdToFactory(@Nullable Iterable<FormatterFactory<?>> factories) {
        LinkedHashMap idToFactory = new LinkedHashMap();
        idToFactory.put(this.getId(), this);
        if (factories != null) {
            for (FormatterFactory<?> factory : factories) {
                String id = factory.getId();
                if (idToFactory.containsKey(id)) continue;
                idToFactory.put(id, factory);
            }
        }
        return CollectionUtils.asImmutableMap(idToFactory);
    }

    @Nonnull
    protected FormatterFactory<?> getFactoryBy(@Nonnull String id) throws IllegalArgumentException {
        FormatterFactory<?> factory = this._idToFactory.get(id);
        if (factory == null) {
            throw new IllegalArgumentException("'" + id + "' is unknown.");
        }
        return factory;
    }

    @Nonnull
    public Iterable<FormatterFactory<?>> getFactories() {
        return this._idToFactory.values();
    }

    @Override
    @Nonnull
    public String getId() {
        return "message";
    }

    @Nonnull
    public MessageFormatter createBy(@Nullable Locale locale, @Nullable String pattern) {
        return this.createBy(locale, pattern, (FormatterFactory)this);
    }

    @Override
    @Nonnull
    public MessageFormatter createBy(@Nullable Locale locale, @Nullable String pattern, @Nonnull FormatterFactory<?> root) {
        this.assertSameRoot(root);
        return this.createByInternal(locale, pattern);
    }

    protected MessageFormatter createByInternal(@Nullable Locale locale, @Nullable String pattern) {
        return new MessageFormatter(locale != null ? locale : Locale.US, pattern, this);
    }

    protected void assertSameRoot(@Nullable FormatterFactory<?> root) {
        if (this != root) {
            throw new IllegalStateException("This formatter factory only accepts itself as root formatter factory.");
        }
    }
}

