/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.locela.api.java.messages;

import java.util.Collections;
import java.util.Iterator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.echocat.locela.api.java.messages.Message;
import org.echocat.locela.api.java.messages.Messages;
import org.echocat.locela.api.java.messages.MessagesSupport;
import org.echocat.locela.api.java.support.CollectionUtils;
import org.echocat.locela.api.java.support.FilterDuplicatesMessagesIterator;

public class CombinedMessages
extends MessagesSupport {
    @Nonnull
    private final Iterable<Messages> _delegates;

    public CombinedMessages(Messages ... delegates) {
        this(CollectionUtils.asList(delegates));
    }

    public CombinedMessages(@Nullable Iterable<Messages> delegates) {
        this._delegates = delegates != null ? delegates : Collections.emptyList();
    }

    @Override
    @Nullable
    public Message find(@Nonnull String id) {
        Messages delegate;
        Message result = null;
        Iterator<Messages> iterator = this.delegates().iterator();
        while (iterator.hasNext() && (result = (delegate = iterator.next()).find(id)) == null) {
        }
        return result;
    }

    @Override
    public boolean contains(@Nonnull String id) {
        Messages delegate;
        boolean result = false;
        Iterator<Messages> iterator = this.delegates().iterator();
        while (iterator.hasNext() && !(result = (delegate = iterator.next()).contains(id))) {
        }
        return result;
    }

    @Override
    public Iterator<Message> iterator() {
        return new FilterDuplicatesMessagesIterator(this.delegates());
    }

    @Nonnull
    protected Iterable<Messages> delegates() {
        return this._delegates;
    }
}

