/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.locela.api.java.messages;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.echocat.locela.api.java.properties.Properties;
import org.echocat.locela.api.java.support.ResourceUtils;

public interface FileAccessor {
    @Nullable
    public Reader open(@Nonnull String var1) throws IOException;

    public static class FileSystemBased
    extends InputStreamBased {
        @Nonnull
        private static final FileSystemBased INSTANCE = new FileSystemBased();

        @Nonnull
        public static FileSystemBased fileSystemFileAccessor() {
            return INSTANCE;
        }

        @Override
        @Nullable
        protected InputStream openStream(@Nonnull String filename) throws IOException {
            FileInputStream is;
            File file = new File(filename);
            if (file.isFile()) {
                try {
                    is = new FileInputStream(file);
                }
                catch (FileNotFoundException ignored) {
                    is = null;
                }
            } else {
                is = null;
            }
            return is;
        }

        public boolean equals(Object o) {
            boolean result = this == o ? true : o != null && this.getClass() == o.getClass();
            return result;
        }

        public int hashCode() {
            return 0;
        }
    }

    public static class ClassLoaderBased
    extends InputStreamBased {
        @Nonnull
        private static final ClassLoaderBased INSTANCE = new ClassLoaderBased(Thread.currentThread().getContextClassLoader());
        @Nonnull
        private final ClassLoader _classLoader;

        @Nonnull
        public static ClassLoaderBased classPathFileAccessor() {
            return INSTANCE;
        }

        public ClassLoaderBased(@Nonnull ClassLoader classLoader) {
            this._classLoader = classLoader;
        }

        @Override
        @Nullable
        protected InputStream openStream(@Nonnull String file) throws IOException {
            String targetFile = file.startsWith("/") ? file.substring(1) : file;
            return this._classLoader.getResourceAsStream(targetFile);
        }

        public boolean equals(Object o) {
            boolean result;
            if (this == o) {
                result = true;
            } else if (o == null || this.getClass() != o.getClass()) {
                result = false;
            } else {
                ClassLoaderBased that = (ClassLoaderBased)o;
                result = this._classLoader.equals(that._classLoader);
            }
            return result;
        }

        public int hashCode() {
            return this._classLoader.hashCode();
        }
    }

    public static abstract class InputStreamBased
    implements FileAccessor {
        public static final Charset CHARSET = Charset.forName(System.getProperty(Properties.class.getName() + ".defaultCharset", "UTF-8"));

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Nullable
        public Reader open(@Nonnull String file) throws IOException {
            boolean success = false;
            InputStream is = this.openStream(file);
            try {
                InputStreamReader reader = is != null ? new InputStreamReader(is, CHARSET) : null;
                success = true;
                InputStreamReader inputStreamReader = reader;
                return inputStreamReader;
            }
            finally {
                if (!success) {
                    ResourceUtils.closeQuietly((AutoCloseable)is);
                }
            }
        }

        @Nullable
        protected abstract InputStream openStream(@Nonnull String var1) throws IOException;
    }
}

