/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.locela.api.java.messages;

import java.util.Collections;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.echocat.locela.api.java.messages.Message;
import org.echocat.locela.api.java.messages.Messages;
import org.echocat.locela.api.java.messages.MessagesSupport;
import org.echocat.locela.api.java.support.CollectionUtils;
import org.echocat.locela.api.java.support.FilterDuplicatesMessagesIterator;
import org.echocat.locela.api.java.support.LocaleHierarchy;

public class LocaleAwareMessages
extends MessagesSupport {
    @Nonnull
    private final LocaleHierarchy _locales;
    @Nonnull
    private final Map<Locale, Messages> _localeToMessages;

    public LocaleAwareMessages(@Nullable Locale locale, @Nullable Map<Locale, Messages> localeToMessages, Locale ... fallbackLocales) {
        this(locale, localeToMessages, CollectionUtils.asList(fallbackLocales));
    }

    public LocaleAwareMessages(@Nullable Locale locale, @Nullable Map<Locale, Messages> localeToMessages, @Nullable Iterable<Locale> fallbackLocales) {
        this._locales = new LocaleHierarchy(locale, fallbackLocales);
        this._localeToMessages = localeToMessages != null ? localeToMessages : Collections.emptyMap();
    }

    @Override
    @Nullable
    public Message find(@Nonnull String id) {
        Locale locale;
        Message message = null;
        Iterator<Locale> iterator = this.locales().iterator();
        while (iterator.hasNext() && (message = this.find(id, locale = iterator.next())) == null) {
        }
        return message;
    }

    @Nullable
    protected Message find(@Nonnull String id, @Nullable Locale locale) {
        Messages messages = this.localeToMessages().get(locale);
        return messages != null ? messages.find(id) : null;
    }

    @Override
    public boolean contains(@Nonnull String id) {
        Locale locale;
        boolean found = false;
        Iterator<Locale> iterator = this.locales().iterator();
        while (iterator.hasNext() && !(found = this.contains(id, locale = iterator.next()))) {
        }
        return found;
    }

    protected boolean contains(@Nonnull String id, @Nullable Locale locale) {
        Messages messages = this.localeToMessages().get(locale);
        return messages != null && messages.contains(id);
    }

    @Override
    public Iterator<Message> iterator() {
        final FilterDuplicatesMessagesIterator i = new FilterDuplicatesMessagesIterator(this.localeToMessages().values());
        return new Iterator<Message>(){
            @Nullable
            private Message _next;

            @Override
            public boolean hasNext() {
                while (this._next == null && i.hasNext()) {
                    Message source = (Message)i.next();
                    this._next = LocaleAwareMessages.this.find(source.getId());
                }
                return this._next != null;
            }

            @Override
            public Message next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Message current = this._next;
                this._next = null;
                return current;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Nullable
    public Locale getLocale() {
        return this.locales().getStart();
    }

    @Nonnull
    protected LocaleHierarchy locales() {
        return this._locales;
    }

    @Nonnull
    protected Map<Locale, Messages> localeToMessages() {
        return this._localeToMessages;
    }

    @Override
    public String toString() {
        return this.getLocale() + ": " + super.toString();
    }
}

