/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.locela.api.java.messages;

import java.io.IOException;
import java.io.StringWriter;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.echocat.locela.api.java.messages.Message;
import org.echocat.locela.api.java.support.StringUtils;

public abstract class MessageSupport
implements Message {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nonnull
    protected String formatInternal(@Nullable Object value) {
        try (StringWriter writer = new StringWriter();){
            this.format(value, writer);
            String string = writer.toString();
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException("IOException in StringWriter?", e);
        }
    }

    @Override
    @Nonnull
    public String format(@Nullable Map<String, ?> values) {
        return this.formatInternal(values);
    }

    @Override
    @Nonnull
    public String format(@Nullable Iterable<?> values) {
        return this.formatInternal(values);
    }

    @Override
    @Nonnull
    public String format(Object ... values) {
        return this.formatInternal(values);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        Locale locale = this.getLocale();
        if (locale != null && !StringUtils.isEmpty(locale.getLanguage())) {
            sb.append('(').append(locale).append(") ");
        }
        sb.append(this.getId()).append(": ").append(this.get());
        return sb.toString();
    }

    public boolean equals(Object o) {
        boolean result;
        if (this == o) {
            result = true;
        } else if (o == null || !(o instanceof Message)) {
            result = false;
        } else {
            Locale locale;
            Message that = (Message)o;
            result = this.getId().equals(that.getId()) ? (((locale = this.getLocale()) != null ? locale.equals(that.getLocale()) : that.getLocale() == null) ? this.get().equals(that.get()) : false) : false;
        }
        return result;
    }

    public int hashCode() {
        Locale locale = this.getLocale();
        int result = locale != null ? locale.hashCode() : 0;
        result = 31 * result + this.getId().hashCode();
        result = 31 * result + this.get().hashCode();
        return result;
    }
}

