/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.locela.api.java.messages;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.echocat.locela.api.java.messages.Message;
import org.echocat.locela.api.java.messages.MessagesSupport;
import org.echocat.locela.api.java.support.CollectionUtils;

public class StandardMessages
extends MessagesSupport {
    @Nonnull
    private final Map<String, Message> _idToMessage = new LinkedHashMap<String, Message>();

    @Nonnull
    public static StandardMessages messagesFor(Message ... messages) {
        return StandardMessages.messagesFor(CollectionUtils.asList(messages));
    }

    @Nonnull
    public static StandardMessages messagesFor(@Nonnull Iterable<Message> messages) {
        return new StandardMessages(messages);
    }

    public StandardMessages(@Nullable Iterable<Message> messages) {
        if (messages != null) {
            for (Message message : messages) {
                if (message == null) continue;
                this._idToMessage.put(message.getId(), message);
            }
        }
    }

    @Override
    @Nonnull
    public Message find(@Nonnull String id) {
        return this.idToMessages().get(id);
    }

    @Override
    public boolean contains(@Nonnull String id) {
        return this.idToMessages().containsKey(id);
    }

    @Override
    public Iterator<Message> iterator() {
        return this.idToMessages().values().iterator();
    }

    @Nonnull
    protected Map<String, Message> idToMessages() {
        return this._idToMessage;
    }
}

