/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.locela.api.java.support;

import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.echocat.locela.api.java.messages.Message;
import org.echocat.locela.api.java.messages.Messages;
import org.echocat.locela.api.java.support.CollectionUtils;

public class FilterDuplicatesMessagesIterator
implements Iterator<Message> {
    @Nonnull
    private final Set<String> _alreadyReturnedMessageIds = new HashSet<String>();
    @Nonnull
    private final Iterator<Messages> _messagesIterator;
    @Nullable
    private Iterator<Message> _messageIterator;
    @Nullable
    private Message _next;

    public FilterDuplicatesMessagesIterator(@Nullable Iterable<Messages> inputs) {
        this(inputs != null ? inputs.iterator() : null);
    }

    public FilterDuplicatesMessagesIterator(@Nullable Iterator<Messages> inputs) {
        this._messagesIterator = inputs != null ? inputs : CollectionUtils.emptyIterator();
    }

    @Override
    public boolean hasNext() {
        while (this._next == null) {
            if (this._messageIterator == null) {
                if (!this._messagesIterator.hasNext()) {
                    return false;
                }
                Messages messages = this._messagesIterator.next();
                this._messageIterator = messages.iterator();
            }
            if (this._messageIterator.hasNext()) {
                Message message = this._messageIterator.next();
                String id = message.getId();
                if (this._alreadyReturnedMessageIds.contains(id)) continue;
                this._next = message;
                this._alreadyReturnedMessageIds.add(id);
                continue;
            }
            this._messageIterator = null;
        }
        return true;
    }

    @Override
    public Message next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        Message next = this._next;
        this._next = null;
        return next;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove");
    }
}

