/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.locela.api.java.support;

import java.util.Iterator;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;

public class IterationUtils {
    @Nonnull
    public static <T> Iterator<T> toIterator(@Nonnull RemoveHandler<T> removeHandler, @Nonnull Iterable<? extends T> source) {
        return IterationUtils.makeRemoveable(removeHandler, source.iterator());
    }

    @Nonnull
    public static <T> Iterator<T> makeRemoveable(final @Nonnull RemoveHandler<T> removeHandler, final @Nonnull Iterator<? extends T> source) {
        final AtomicReference last = new AtomicReference();
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return source.hasNext();
            }

            @Override
            public T next() {
                Object next = source.next();
                last.set(next);
                return next;
            }

            @Override
            public void remove() {
                Object element = last.get();
                if (element == null) {
                    throw new IllegalStateException();
                }
                removeHandler.remove(element);
            }
        };
    }

    public static interface RemoveHandler<T> {
        public void remove(@Nonnull T var1);
    }
}

