/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.locela.api.java.support;

import java.util.Collections;
import java.util.Iterator;
import java.util.Locale;
import javax.annotation.Nullable;
import org.echocat.locela.api.java.support.CollectionUtils;
import org.echocat.locela.api.java.support.LocaleHierarchyIterator;

public class LocaleHierarchy
implements Iterable<Locale> {
    @Nullable
    private final Locale _start;
    @Nullable
    private final Iterable<Locale> _fallbacks;

    public LocaleHierarchy(@Nullable Locale start) {
        this(start, Collections.emptyList());
    }

    public LocaleHierarchy(@Nullable Locale start, Locale ... fallbacks) {
        this(start, CollectionUtils.asList(fallbacks));
    }

    public LocaleHierarchy(@Nullable Locale start, @Nullable Iterable<Locale> fallbacks) {
        this._start = start;
        this._fallbacks = fallbacks;
    }

    @Override
    public Iterator<Locale> iterator() {
        return new LocaleHierarchyIterator(this.getStart(), this.getFallbacks());
    }

    @Nullable
    public Locale getStart() {
        return this._start;
    }

    @Nullable
    public Iterable<Locale> getFallbacks() {
        return this._fallbacks;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        sb.append('[');
        for (Locale locale : this) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(locale);
        }
        sb.append(']');
        return sb.toString();
    }
}

