/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.locela.api.java.support;

import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.echocat.locela.api.java.support.LocaleHierarchyIterator;
import org.echocat.locela.api.java.support.LocaleNormelizer;
import org.echocat.locela.api.java.utils.CollectionUtils;
import org.echocat.locela.api.java.utils.StringUtils;

public class StandardLocaleNormelizer
implements LocaleNormelizer {
    private static final Locale NONE = new Locale("");
    private static final Locale[] CONTAINS_NULL = new Locale[]{null};
    @Nonnull
    private final List<Locale> _allowedLocales;
    @Nullable
    private final Locale _defaultLocale;

    public StandardLocaleNormelizer(@Nullable Locale defaultLocale, Locale ... allowedLocales) {
        this(defaultLocale, CollectionUtils.asList(allowedLocales));
    }

    public StandardLocaleNormelizer(@Nullable Locale defaultLocale, @Nullable Iterable<Locale> allowedLocales) {
        this._defaultLocale = defaultLocale;
        this._allowedLocales = CollectionUtils.asImmutableList(allowedLocales);
    }

    @Override
    @Nullable
    public Locale normelize(@Nullable Locale input) {
        Locale result = NONE;
        if (this.allowedLocales().contains(input)) {
            result = input;
        } else {
            LocaleHierarchyIterator i = new LocaleHierarchyIterator(input);
            if (i.hasNext()) {
                i.next();
            }
            block0: while (i.hasNext() && result == NONE) {
                Locale subLocale = (Locale)i.next();
                if (StringUtils.isEmpty(subLocale.getLanguage())) continue;
                for (Locale candidate : this.allowedLocales()) {
                    if (!this.startsWith(candidate, subLocale)) continue;
                    result = candidate;
                    continue block0;
                }
            }
            if (result == NONE) {
                result = this.defaultLocale();
            }
        }
        return result;
    }

    protected boolean startsWith(@Nullable Locale toTest, @Nullable Locale with) {
        String variant;
        String country;
        String language;
        boolean result = toTest != null && with != null ? (!StringUtils.isEmpty(language = with.getLanguage()) ? (language.equals(toTest.getLanguage()) ? (!StringUtils.isEmpty(country = with.getCountry()) ? (country.equals(toTest.getCountry()) ? (!StringUtils.isEmpty(variant = with.getCountry()) ? variant.equals(toTest.getCountry()) : true) : false) : true) : false) : true) : toTest == null && with == null;
        return result;
    }

    @Nonnull
    protected List<Locale> allowedLocales() {
        return this._allowedLocales;
    }

    @Nullable
    protected Locale defaultLocale() {
        return this._defaultLocale;
    }
}

