/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.locela.api.java.annotations;

import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.echocat.locela.api.java.annotations.Annotation;
import org.echocat.locela.api.java.annotations.AnnotationParser;
import org.echocat.locela.api.java.annotations.CommentAnnotation;
import org.echocat.locela.api.java.utils.CollectionUtils;

@ThreadSafe
public class AnnotationsParser {
    private static final AnnotationsParser INSTANCE = new AnnotationsParser();
    @Nonnull
    private final AnnotationParser _annotaionParser;

    @Nonnull
    public static AnnotationsParser annotationsParser() {
        return INSTANCE;
    }

    public AnnotationsParser() {
        this(null);
    }

    public AnnotationsParser(@Nullable AnnotationParser annotaionParser) {
        this._annotaionParser = annotaionParser != null ? annotaionParser : AnnotationParser.annotationParser();
    }

    @Nonnull
    public Iterable<Annotation> parse(@Nullable String plain) {
        String extractedComment;
        ArrayList<Annotation> result = new ArrayList<Annotation>();
        StringBuilder comment = new StringBuilder();
        StringBuilder sb = new StringBuilder();
        char[] chars = plain.toCharArray();
        boolean lineBeginning = true;
        boolean atFound = false;
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (c == ' ' || c == '\t') {
                if (lineBeginning) continue;
                if (atFound) {
                    sb.append(c);
                    continue;
                }
                comment.append(c);
                continue;
            }
            if (c == '\r' || c == '\n') {
                if (!lineBeginning) {
                    if (atFound) {
                        result.add(this.annotationParser().parse(sb.toString()));
                        sb.setLength(0);
                        atFound = false;
                    } else {
                        comment.append(c);
                    }
                    lineBeginning = true;
                    continue;
                }
                if (atFound) continue;
                comment.append(c);
                continue;
            }
            if (c == '@' && lineBeginning) {
                atFound = true;
                String extractedComment2 = comment.toString().trim();
                comment.setLength(0);
                if (extractedComment2.isEmpty()) continue;
                result.add(new CommentAnnotation(extractedComment2));
                continue;
            }
            lineBeginning = false;
            if (atFound) {
                sb.append(c);
                continue;
            }
            comment.append(c);
        }
        if (atFound) {
            result.add(this.annotationParser().parse(sb.toString()));
        }
        if (!(extractedComment = comment.toString().trim()).isEmpty()) {
            result.add(new CommentAnnotation(extractedComment));
        }
        return CollectionUtils.asImmutableList(result);
    }

    @Nonnull
    protected AnnotationParser annotationParser() {
        return this._annotaionParser;
    }
}

