/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.locela.api.java.messages;

import java.io.IOException;
import java.io.Writer;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.echocat.locela.api.java.format.Formatter;
import org.echocat.locela.api.java.format.FormatterFactory;
import org.echocat.locela.api.java.format.MessageFormatterFactory;
import org.echocat.locela.api.java.messages.MessageSupport;

public abstract class FormattingMessageSupport
extends MessageSupport {
    protected static final Locale DEFAULT_LOCALE = Locale.US;
    @Nonnull
    private final FormatterFactory<?> _formatterFactory;
    @Nullable
    private Formatter _formatter;

    public FormattingMessageSupport(@Nullable FormatterFactory<?> formatterFactory) {
        this._formatterFactory = formatterFactory != null ? formatterFactory : MessageFormatterFactory.messageFormatterFactory();
    }

    @Override
    public void format(@Nullable Object value, @Nonnull Writer to) throws IOException {
        this.formatter().format(value, to);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    protected Formatter formatter() {
        FormattingMessageSupport formattingMessageSupport = this;
        synchronized (formattingMessageSupport) {
            if (this._formatter == null) {
                Locale locale = this.getLocale();
                this._formatter = this._formatterFactory.createBy(locale != null ? locale : DEFAULT_LOCALE, this.get(), this._formatterFactory);
            }
            return this._formatter;
        }
    }
}

