/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.locela.api.java.messages;

import java.io.IOException;
import java.io.Reader;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.echocat.locela.api.java.format.FormatterFactory;
import org.echocat.locela.api.java.format.MessageFormatterFactory;
import org.echocat.locela.api.java.messages.FileAccessor;
import org.echocat.locela.api.java.messages.Messages;
import org.echocat.locela.api.java.messages.MessagesProviderSupport;
import org.echocat.locela.api.java.messages.PropertiesMessages;
import org.echocat.locela.api.java.properties.Properties;
import org.echocat.locela.api.java.properties.PropertiesReader;
import org.echocat.locela.api.java.properties.StandardPropertiesReader;
import org.echocat.locela.api.java.utils.FilenameUtils;
import org.echocat.locela.api.java.utils.StringUtils;

public class StandardMessagesProvider
extends MessagesProviderSupport {
    private static final StandardMessagesProvider INSTANCE = new StandardMessagesProvider();
    @Nonnull
    private final PropertiesReader _propertiesReader;
    @Nonnull
    private final FormatterFactory<?> _formatterFactory;

    @Nonnull
    public static StandardMessagesProvider messagesProvider() {
        return INSTANCE;
    }

    public StandardMessagesProvider() {
        this(null, null);
    }

    public StandardMessagesProvider(@Nullable PropertiesReader propertiesReader, @Nonnull FormatterFactory<?> formatterFactory) {
        this._propertiesReader = propertiesReader != null ? propertiesReader : StandardPropertiesReader.propertiesReader();
        this._formatterFactory = formatterFactory != null ? formatterFactory : MessageFormatterFactory.messageFormatterFactory();
    }

    @Override
    @Nullable
    public Messages provideBy(@Nullable Locale locale, @Nonnull FileAccessor accessor, @Nonnull String baseFile) throws IOException {
        PropertiesMessages result;
        String file = this.buildFileFrom(locale, baseFile);
        try (Reader reader = accessor.open(file);){
            if (reader != null) {
                Properties<String> properties = this.propertiesReader().read(reader);
                result = new PropertiesMessages(locale, properties, this.formatterFactory());
            } else {
                result = null;
            }
        }
        return result;
    }

    @Nonnull
    protected String buildFileFrom(@Nullable Locale locale, @Nonnull String baseFile) {
        String prefix = FilenameUtils.removeExtension(baseFile);
        String suffix = FilenameUtils.getExtension(baseFile);
        StringBuilder sb = new StringBuilder();
        sb.append(prefix);
        if (!this.isEmpty(locale)) {
            sb.append('_').append(locale);
        }
        if (!StringUtils.isEmpty(suffix)) {
            sb.append('.').append(suffix);
        }
        return sb.toString();
    }

    protected boolean isEmpty(@Nullable Locale locale) {
        boolean result = locale == null ? true : StringUtils.isEmpty(locale.getLanguage()) && StringUtils.isEmpty(locale.getCountry()) && StringUtils.isEmpty(locale.getVariant());
        return result;
    }

    @Nonnull
    protected PropertiesReader propertiesReader() {
        return this._propertiesReader;
    }

    @Nonnull
    protected FormatterFactory<?> formatterFactory() {
        return this._formatterFactory;
    }
}

