/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.locela.api.java.properties;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.echocat.locela.api.java.annotations.Annotation;
import org.echocat.locela.api.java.properties.PropertySupport;

@NotThreadSafe
public class StandardProperty<V>
extends PropertySupport<V> {
    @Nonnull
    private final String _id;
    @Nonnull
    private final Class<V> _type;
    @Nullable
    private volatile V _content;

    @Nonnull
    public static <V> StandardProperty<V> property(@Nonnull String id, @Nonnull Class<V> ofType) {
        return new StandardProperty<V>(id, ofType);
    }

    @Nonnull
    public static StandardProperty<String> property(@Nonnull String id) {
        return StandardProperty.property(id, String.class);
    }

    public StandardProperty(@Nonnull String id, @Nonnull Class<V> type) {
        this._id = id;
        this._type = type;
    }

    @Nonnull
    public StandardProperty<V> withAnnotations(Annotation ... annotations) {
        this.addAnnotations(annotations);
        return this;
    }

    @Nonnull
    public StandardProperty<V> withAnnotations(@Nullable Iterable<? extends Annotation> annotations) {
        this.addAnnotations(annotations);
        return this;
    }

    @Override
    @Nonnull
    public String getId() {
        return this._id;
    }

    @Override
    @Nullable
    public V get() {
        return this._content;
    }

    @Override
    public StandardProperty<V> set(@Nullable V content) throws IllegalArgumentException {
        if (content != null && !this.getType().isInstance(content)) {
            throw new IllegalArgumentException("Expected content of type '" + this.getType().getName() + "' but got: " + content);
        }
        this._content = content;
        return this;
    }

    @Override
    public Class<V> getType() {
        return this._type;
    }
}

