/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.locela.api.java.utils;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.echocat.locela.api.java.utils.CloseableIterator;
import org.echocat.locela.api.java.utils.ResourceUtils;

public class CollectionUtils {
    @Nonnull
    public static <K, V> Map<K, V> putAll(@Nonnull Map<K, V> original, Object ... a) {
        if (a != null) {
            int length = a.length;
            if (length % 2 == 1) {
                throw new IllegalArgumentException("You must provide an even number of arguments.");
            }
            for (int i = 0; i < length; i += 2) {
                original.put(a[i], a[i + 1]);
            }
        }
        return original;
    }

    @Nonnull
    public static <K, V> Map<K, V> asMap(Object ... a) {
        return CollectionUtils.putAll(new LinkedHashMap(), a);
    }

    @Nonnull
    public static <K, V> Map<K, V> putAllAndMakeImmutable(@Nonnull Map<K, V> original, Object ... a) {
        return CollectionUtils.asImmutableMap(CollectionUtils.putAll(original, a));
    }

    @Nonnull
    public static <K, V> Map<K, V> asImmutableMap(Object ... a) {
        return CollectionUtils.putAllAndMakeImmutable(new LinkedHashMap(), a);
    }

    @Nonnull
    public static <K, V> Map<K, V> asImmutableMap(@Nullable Map<K, V> map) {
        return map != null ? Collections.unmodifiableMap(map) : Collections.emptyMap();
    }

    @Nonnull
    public static <T, C extends Collection<T>> C addAll(@Nonnull C to, T ... elements) {
        if (elements != null) {
            Collections.addAll(to, elements);
        }
        return to;
    }

    @Nonnull
    public static <T, C extends Collection<T>> C addAll(@Nonnull C to, @Nullable Iterable<T> elements) {
        if (elements != null) {
            try {
                CollectionUtils.addAll(to, elements.iterator());
            }
            finally {
                ResourceUtils.closeQuietlyIfAutoCloseable(elements);
            }
        }
        return to;
    }

    @Nonnull
    public static <T, C extends Collection<T>> C addAll(@Nonnull C to, @Nullable Iterator<T> elements) {
        if (elements != null) {
            try {
                while (elements.hasNext()) {
                    to.add(elements.next());
                }
            }
            finally {
                ResourceUtils.closeQuietlyIfAutoCloseable(elements);
            }
        }
        return to;
    }

    @Nonnull
    public static <T> Collection<T> asCollection(@Nullable Iterable<T> in) {
        List<T> result = in instanceof Collection ? (List<T>)in : CollectionUtils.asList(in);
        return result;
    }

    @Nonnull
    public static <T> List<T> asList(T ... objects) {
        ArrayList result;
        if (objects == null) {
            result = new ArrayList();
        } else {
            int initialCapacity = Math.max(16, (objects.length + 2) / 3 * 4);
            result = new ArrayList(initialCapacity);
            result.addAll(new ArrayWrapper(objects));
        }
        return result;
    }

    @Nonnull
    public static <T> List<T> asImmutableList(T ... objects) {
        return Collections.unmodifiableList(CollectionUtils.asList(objects));
    }

    @Nonnull
    public static <T> List<T> asList(@Nullable Iterator<T> iterator) {
        ArrayList<T> result = new ArrayList<T>();
        try {
            if (iterator != null) {
                while (iterator.hasNext()) {
                    result.add(iterator.next());
                }
            }
        }
        finally {
            ResourceUtils.closeQuietlyIfAutoCloseable(iterator);
        }
        return result;
    }

    @Nonnull
    public static <T> List<T> asList(@Nullable Iterable<T> in) {
        ArrayList result;
        if (in instanceof List) {
            result = (ArrayList)in;
        } else if (in instanceof Collection) {
            result = new ArrayList((Collection)in);
        } else {
            result = new ArrayList();
            CollectionUtils.addAll(result, in);
        }
        return result;
    }

    @Nonnull
    public static <T> List<T> asList(@Nullable Enumeration<T> in) {
        ArrayList<T> result = new ArrayList<T>();
        while (in != null && in.hasMoreElements()) {
            result.add(in.nextElement());
        }
        return result;
    }

    @Nonnull
    public static <T> List<T> asImmutableList(@Nullable Iterable<T> in) {
        return Collections.unmodifiableList(CollectionUtils.asList(in));
    }

    @Nonnull
    public static <T> Set<T> asSet(@Nullable Iterable<T> in) {
        Set result = in instanceof Set ? (LinkedHashSet)in : (in instanceof Collection ? new LinkedHashSet((Collection)in) : (Set)CollectionUtils.addAll(new LinkedHashSet(), in));
        return result;
    }

    @Nonnull
    public static <T> Set<T> asImmutableSet(@Nullable Iterable<T> in) {
        return Collections.unmodifiableSet(CollectionUtils.asSet(in));
    }

    @Nonnull
    public static <T> CloseableIterator<T> emptyIterator() {
        return new CloseableIterator<T>(){

            @Override
            public boolean hasNext() {
                return false;
            }

            @Override
            public T next() {
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void close() {
            }
        };
    }

    @Nonnegative
    public static <T> long countElementsOf(@Nullable Iterable<T> iterable) {
        return iterable != null ? CollectionUtils.countElementsOf(iterable.iterator()) : 0L;
    }

    @Nonnegative
    public static <T> long countElementsOf(@Nullable Iterator<T> iterator) {
        long count = 0L;
        try {
            if (iterator != null) {
                while (iterator.hasNext()) {
                    iterator.next();
                    ++count;
                }
            }
        }
        finally {
            ResourceUtils.closeQuietlyIfAutoCloseable(iterator);
        }
        return count;
    }

    private CollectionUtils() {
    }

    private static class ArrayWrapper<E>
    extends AbstractList<E> {
        private final E[] _wrappedArray;

        private ArrayWrapper(E[] arrayToWrap) {
            this._wrappedArray = arrayToWrap;
        }

        @Override
        public E get(int index) {
            return this._wrappedArray[index];
        }

        @Override
        public int size() {
            return this._wrappedArray.length;
        }

        @Override
        public Object[] toArray() {
            return this._wrappedArray;
        }
    }
}

