/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.locela.api.java.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;

public class IOUtils {
    public static String toString(Reader input) throws IOException {
        try (StringWriter writer = new StringWriter();){
            IOUtils.copy(input, writer);
            String string = writer.toString();
            return string;
        }
    }

    public static int copy(InputStream input, OutputStream output) throws IOException {
        long count = IOUtils.copyLarge(input, output);
        if (count > Integer.MAX_VALUE) {
            return -1;
        }
        return (int)count;
    }

    public static int copy(Reader input, Writer output) throws IOException {
        long count = IOUtils.copyLarge(input, output);
        if (count > Integer.MAX_VALUE) {
            return -1;
        }
        return (int)count;
    }

    public static long copyLarge(InputStream input, OutputStream output) throws IOException {
        int n;
        byte[] buffer = new byte[4096];
        long count = 0L;
        while ((n = input.read(buffer)) != -1) {
            output.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }

    public static long copyLarge(Reader input, Writer output) throws IOException {
        int n;
        char[] buffer = new char[4096];
        long count = 0L;
        while ((n = input.read(buffer)) != -1) {
            output.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }
}

