/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.locela.api.java.annotations;

import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import org.echocat.locela.api.java.annotations.Annotation;

@ThreadSafe
public class AnnotationFormatter {
    private static final AnnotationFormatter INSTANCE = new AnnotationFormatter();

    @Nonnull
    public static AnnotationFormatter annotationFormatter() {
        return INSTANCE;
    }

    @Nonnull
    public String format(@Nonnull Annotation annotation) {
        StringBuilder sb = new StringBuilder();
        sb.append(annotation.getId()).append('(');
        boolean first = true;
        for (Object argument : annotation.getArguments()) {
            if (first) {
                first = false;
            } else {
                sb.append(',');
            }
            this.formatArgument(annotation, argument, sb);
        }
        sb.append(')');
        return sb.toString();
    }

    protected void formatArgument(@Nonnull Annotation annotation, @Nonnull Object argument, @Nonnull StringBuilder to) {
        if (argument == null) {
            to.append("null");
        } else if (argument instanceof String) {
            this.formatString((String)argument, to);
        } else if (argument instanceof Boolean) {
            to.append(argument);
        } else if (argument instanceof Number) {
            to.append(((Number)argument).doubleValue());
        } else {
            throw new IllegalArgumentException("Could not format arguments of type " + argument.getClass().getName() + " for annotation " + annotation.getId() + ".");
        }
    }

    protected void formatString(@Nonnull String argument, @Nonnull StringBuilder to) {
        char[] chars = argument.toCharArray();
        to.append('\"');
        for (char c : chars) {
            if (c == '\n') {
                to.append("\\n");
                continue;
            }
            if (c == '\r') {
                to.append("\\r");
                continue;
            }
            if (c == '\t') {
                to.append("\\t");
                continue;
            }
            if (c == '\\') {
                to.append("\\\\");
                continue;
            }
            if (c == '\"') {
                to.append("\\\"");
                continue;
            }
            to.append(c);
        }
        to.append('\"');
    }
}

