/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.locela.api.java.support;

import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.echocat.locela.api.java.messages.LocaleHierarchyAwareMessagesProvider;
import org.echocat.locela.api.java.messages.MessagesProvider;
import org.echocat.locela.api.java.messages.RecursiveMessagesProvider;
import org.echocat.locela.api.java.support.LocaleNormalizer;
import org.echocat.locela.api.java.support.StandardLocaleNormalizer;
import org.echocat.locela.api.java.utils.CollectionUtils;

public class LocaleHierarchyAwareFactory {
    @Nonnull
    private final List<Locale> _allowedLocales;
    @Nullable
    private final Locale _fallbackLocale;

    public LocaleHierarchyAwareFactory(@Nullable Locale fallbackLocale, Locale ... allowedLocales) {
        this(fallbackLocale, CollectionUtils.asList(allowedLocales));
    }

    public LocaleHierarchyAwareFactory(@Nullable Locale fallbackLocale, @Nullable Iterable<Locale> allowedLocales) {
        this._fallbackLocale = fallbackLocale;
        this._allowedLocales = CollectionUtils.asImmutableList(allowedLocales);
    }

    @Nonnull
    public MessagesProvider createMessagesProvider() {
        LocaleHierarchyAwareMessagesProvider localeHierarchyAwareMessagesProvider = new LocaleHierarchyAwareMessagesProvider(this._allowedLocales, CollectionUtils.asImmutableList(this._fallbackLocale));
        return new RecursiveMessagesProvider(localeHierarchyAwareMessagesProvider);
    }

    @Nonnull
    public LocaleNormalizer createLocaleNormalizer() {
        return new StandardLocaleNormalizer(this._fallbackLocale, this._allowedLocales);
    }

    @Nonnull
    public List<Locale> getAllowedLocales() {
        return this._allowedLocales;
    }

    @Nullable
    public Locale getFallbackLocale() {
        return this._fallbackLocale;
    }
}

