/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.locela.api.java.messages;

import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.echocat.locela.api.java.messages.FileAccessor;
import org.echocat.locela.api.java.messages.LocaleAwareMessages;
import org.echocat.locela.api.java.messages.Messages;
import org.echocat.locela.api.java.messages.MessagesProvider;
import org.echocat.locela.api.java.messages.MessagesProviderSupport;
import org.echocat.locela.api.java.messages.StandardMessagesProvider;

public class LocaleHierarchyAwareMessagesProvider
extends MessagesProviderSupport {
    @Nonnull
    private final MessagesProvider _delegate;
    @Nonnull
    private final Iterable<Locale> _locales;
    @Nonnull
    private final Iterable<Locale> _fallbackLocales;

    public LocaleHierarchyAwareMessagesProvider(@Nullable Iterable<Locale> locales) {
        this(locales, null);
    }

    public LocaleHierarchyAwareMessagesProvider(@Nullable Iterable<Locale> locales, @Nullable Iterable<Locale> fallbackLocales) {
        this(null, locales, fallbackLocales);
    }

    public LocaleHierarchyAwareMessagesProvider(@Nullable MessagesProvider delegate, @Nullable Iterable<Locale> locales, @Nullable Iterable<Locale> fallbackLocales) {
        this._delegate = delegate != null ? delegate : StandardMessagesProvider.messagesProvider();
        this._locales = locales != null ? locales : Collections.emptyList();
        this._fallbackLocales = fallbackLocales != null ? fallbackLocales : Collections.emptyList();
    }

    @Override
    @Nullable
    public Messages provideBy(@Nullable Locale locale, @Nonnull FileAccessor accessor, @Nonnull String baseFile) throws IOException {
        Map<Locale, Messages> localeToMessages = this.provideLocaleToMessagesBy(accessor, baseFile);
        return !localeToMessages.isEmpty() ? new LocaleAwareMessages(locale, localeToMessages, this.fallbackLocales()) : null;
    }

    @Nonnull
    protected Map<Locale, Messages> provideLocaleToMessagesBy(@Nonnull FileAccessor accessor, @Nonnull String baseFile) throws IOException {
        LinkedHashMap<Locale, Messages> result = new LinkedHashMap<Locale, Messages>();
        for (Locale locale : this.locales()) {
            Messages messages = this.delegate().provideBy(locale, accessor, baseFile);
            if (messages == null) continue;
            result.put(locale, messages);
        }
        return result;
    }

    @Nonnull
    protected MessagesProvider delegate() {
        return this._delegate;
    }

    @Nonnull
    protected Iterable<Locale> locales() {
        return this._locales;
    }

    @Nonnull
    protected Iterable<Locale> fallbackLocales() {
        return this._fallbackLocales;
    }
}

