/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.locela.api.java.support;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.echocat.locela.api.java.utils.CollectionUtils;
import org.echocat.locela.api.java.utils.StringUtils;

public class LocaleHierarchyIterator
implements Iterator<Locale> {
    @Nonnull
    private final Set<Locale> _alreadyReturned = new HashSet<Locale>();
    @Nonnull
    private final Iterator<Locale> _fallbacks;
    @Nullable
    private Boolean _hasNext = true;
    @Nullable
    private Locale _next;
    private boolean _disassembleLocale = true;

    public LocaleHierarchyIterator(@Nullable Locale start) {
        this(start, (Iterator<Locale>)null);
    }

    public LocaleHierarchyIterator(@Nullable Locale start, @Nullable Iterable<Locale> fallbacks) {
        this(start, fallbacks != null ? fallbacks.iterator() : null);
    }

    public LocaleHierarchyIterator(@Nullable Locale start, @Nullable Iterator<Locale> fallbacks) {
        this._next = start;
        this._fallbacks = fallbacks != null ? fallbacks : CollectionUtils.emptyIterator();
    }

    @Override
    public boolean hasNext() {
        while (this._hasNext == null) {
            if (this._hasNext == null && this.isDisassembleLocale() && this._next != null) {
                String variant = this._next.getVariant();
                if (!StringUtils.isEmpty(variant)) {
                    this._next = new Locale(this._next.getLanguage(), this._next.getCountry());
                    this._hasNext = true;
                } else {
                    String country = this._next.getCountry();
                    if (!StringUtils.isEmpty(country)) {
                        this._next = new Locale(this._next.getLanguage());
                        this._disassembleLocale = false;
                        this._hasNext = true;
                    }
                }
            }
            if (this._hasNext == null) {
                if (this.fallbacks().hasNext()) {
                    this._disassembleLocale = false;
                    this._hasNext = true;
                    this._next = this.fallbacks().next();
                } else {
                    this._hasNext = false;
                }
            }
            if (!this._hasNext.booleanValue()) continue;
            if (this._alreadyReturned.contains(this._next)) {
                this._hasNext = null;
                continue;
            }
            this._alreadyReturned.add(this._next);
        }
        return this._hasNext != null && this._hasNext != false;
    }

    @Override
    public Locale next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this._hasNext = null;
        return this._next;
    }

    @Nonnull
    protected Iterator<Locale> fallbacks() {
        return this._fallbacks;
    }

    protected boolean isDisassembleLocale() {
        return this._disassembleLocale;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

