package org.echocat.locela.api.java.utils;

import java.io.*;

public class IOUtils {

    public static String toString(Reader input) throws IOException {
        try (final StringWriter writer = new StringWriter()) {
            copy(input, writer);
            return writer.toString();
        }
    }

    public static int copy(InputStream input, OutputStream output) throws IOException {
        final long count = copyLarge(input, output);
        if (count > Integer.MAX_VALUE) {
            return -1;
        }
        return (int) count;
    }

    public static int copy(Reader input, Writer output) throws IOException {
        final long count = copyLarge(input, output);
        if (count > Integer.MAX_VALUE) {
            return -1;
        }
        return (int) count;
    }

    public static long copyLarge(InputStream input, OutputStream output) throws IOException {
        final byte[] buffer = new byte[4096];
        long count = 0;
        int n;
        while ((n = input.read(buffer)) != -1) {
            output.write(buffer, 0, n);
            count += n;
        }
        return count;
    }

    public static long copyLarge(Reader input, Writer output) throws IOException {
        final char[] buffer = new char[4096];
        long count = 0;
        int n;
        while ((n = input.read(buffer)) != -1) {
            output.write(buffer, 0, n);
            count += n;
        }
        return count;
    }

}
