/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.locela.api.java.annotations;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.echocat.locela.api.java.annotations.Annotation;
import org.echocat.locela.api.java.annotations.StandardAnnotationFactoryProvider;

@ThreadSafe
public class AnnotationParser {
    private static final AnnotationParser INSTANCE = new AnnotationParser();
    @Nonnull
    private final Annotation.Factory.Provider _annotationFactoryProvider;

    @Nonnull
    public static AnnotationParser annotationParser() {
        return INSTANCE;
    }

    public AnnotationParser() {
        this(null);
    }

    public AnnotationParser(@Nullable Annotation.Factory.Provider provider) {
        this._annotationFactoryProvider = provider != null ? provider : StandardAnnotationFactoryProvider.annotaionFactoryProvider();
    }

    @Nonnull
    public Annotation parse(@Nonnull String plain) throws IllegalArgumentException {
        char[] chars = plain.toCharArray();
        Extraction<String> id = this.extractId(chars, 0);
        Extraction<List<Object>> plainObjects = this.extractObjects(chars, id.getEnd());
        Annotation.Factory<? extends Annotation> factory = this.annotationFactoryProvider().provideBy(id.getContent());
        return factory.createBy(plainObjects.getContent().toArray());
    }

    @Nonnull
    protected Extraction<String> extractId(@Nonnull char[] chars, @Nonnegative int begin) {
        int i;
        StringBuilder sb = new StringBuilder();
        boolean idFinished = false;
        boolean foundBracket = false;
        for (i = begin; i < chars.length; ++i) {
            char c = chars[i];
            if (c == ' ' || c == '\t') {
                if (sb.length() <= 0) continue;
                idFinished = true;
                continue;
            }
            if (c == '(') {
                idFinished = true;
                foundBracket = true;
                break;
            }
            if (this.isValidIdCharacter(c)) {
                if (idFinished) {
                    throw new IllegalArgumentException("Unexpected character '" + c + "'.");
                }
                sb.append(c);
                continue;
            }
            throw new IllegalArgumentException("Unexpected character '" + c + "'.");
        }
        if (sb.length() <= 0) {
            throw new IllegalArgumentException("Unexpected end of annotation id.");
        }
        if (!foundBracket) {
            throw new IllegalArgumentException("Unexpected end of annotation id. Bracket missing");
        }
        return new Extraction<String>(sb.toString(), i + 1);
    }

    @Nonnull
    protected Extraction<List<Object>> extractObjects(@Nonnull char[] chars, @Nonnegative int begin) {
        int i;
        ArrayList<Object> objects = new ArrayList<Object>();
        StringBuilder sb = new StringBuilder();
        boolean inString = false;
        boolean expectString = false;
        boolean objectEnded = false;
        boolean foundClosingBracket = false;
        for (i = begin; i < chars.length; ++i) {
            char c = chars[i];
            if (foundClosingBracket && c != ' ' && c != '\t') {
                throw new IllegalArgumentException("Unexpected character after closing bracket: " + c);
            }
            if (c == '\"') {
                if (inString) {
                    inString = false;
                    objectEnded = true;
                    continue;
                }
                if (sb.length() > 0) {
                    throw new IllegalArgumentException("Unexpected begin of string at position " + i + " after recorded '" + sb + "'.");
                }
                inString = true;
                expectString = true;
                continue;
            }
            if (c == '\\') {
                if (i + 1 < chars.length) {
                    char nc;
                    if ((nc = chars[++i]) == 'n') {
                        sb.append('\n');
                        continue;
                    }
                    if (nc == 'r') {
                        sb.append('\r');
                        continue;
                    }
                    if (nc == 't') {
                        sb.append('\t');
                        continue;
                    }
                    sb.append(nc);
                    continue;
                }
                throw new IllegalArgumentException("Unexpected end of annotation pattern after escape: \\");
            }
            if (inString) {
                sb.append(c);
                continue;
            }
            if (c == ' ' || c == '\t') {
                if (sb.length() <= 0) continue;
                objectEnded = true;
                continue;
            }
            if (c == ',') {
                objects.add(this.evalObject(sb.toString(), expectString));
                sb.setLength(0);
                objectEnded = false;
                expectString = false;
                continue;
            }
            if (c == ')') {
                if (!objects.isEmpty() || sb.length() > 0 || expectString) {
                    objects.add(this.evalObject(sb.toString(), expectString));
                }
                foundClosingBracket = true;
                continue;
            }
            if (objectEnded) {
                throw new IllegalArgumentException("Unexpected character after end of literal (" + sb + "): " + c);
            }
            sb.append(c);
        }
        if (!foundClosingBracket) {
            throw new IllegalArgumentException("Could not find closing bracket.");
        }
        return new Extraction<List<Object>>(objects, i);
    }

    @Nullable
    private Object evalObject(@Nonnull String plain, boolean expectString) {
        Object result;
        if (expectString) {
            result = plain;
        } else {
            if (plain.isEmpty()) {
                throw new IllegalArgumentException("Missing literal.");
            }
            if ("null".equalsIgnoreCase(plain)) {
                result = null;
            } else if ("true".equalsIgnoreCase(plain) || "on".equalsIgnoreCase(plain) || "yes".equalsIgnoreCase(plain)) {
                result = true;
            } else if ("false".equalsIgnoreCase(plain) || "off".equalsIgnoreCase(plain) || "no".equalsIgnoreCase(plain)) {
                result = false;
            } else {
                try {
                    result = Double.valueOf(plain);
                }
                catch (NumberFormatException ignored) {
                    throw new IllegalArgumentException("No valid literal: " + plain);
                }
            }
        }
        return result;
    }

    @Nonnull
    protected Annotation.Factory.Provider annotationFactoryProvider() {
        return this._annotationFactoryProvider;
    }

    protected boolean isValidIdCharacter(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '-' || c == '_' || c == '.';
    }

    protected static class Extraction<T> {
        @Nonnull
        private final T _content;
        @Nonnegative
        private final int _end;

        public Extraction(@Nonnull T content, int end) {
            this._content = content;
            this._end = end;
        }

        @Nonnull
        public T getContent() {
            return this._content;
        }

        @Nonnegative
        public int getEnd() {
            return this._end;
        }
    }
}

