/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.locela.api.java.properties;

import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.echocat.locela.api.java.annotations.Annotation;
import org.echocat.locela.api.java.properties.PropertiesSupport;
import org.echocat.locela.api.java.properties.Property;

@NotThreadSafe
public class StandardProperties<V>
extends PropertiesSupport<V> {
    @Nonnull
    private final Map<String, Property<V>> _idToProperty = new LinkedHashMap<String, Property<V>>();

    @SafeVarargs
    @Nonnull
    public static <V> StandardProperties<V> properties(Property<V> ... properties) {
        return new StandardProperties<V>().withProperties(properties);
    }

    @Nonnull
    protected Map<String, Property<V>> idToProperty() {
        return this._idToProperty;
    }

    @Override
    public void add(@Nonnull Property<? extends V> property) {
        this.idToProperty().put(property.getId(), property);
    }

    @Override
    @Nullable
    public Property<V> get(@Nonnull String id) {
        return this.idToProperty().get(id);
    }

    @Override
    public boolean contains(@Nonnull String id) {
        return this.idToProperty().containsKey(id);
    }

    @Override
    public void remove(@Nonnull String id) {
        this.idToProperty().remove(id);
    }

    @Override
    @Nonnull
    protected Iterable<? extends Property<V>> getProperties() {
        return this.idToProperty().values();
    }

    @Nonnull
    public StandardProperties<V> withAnnotations(Annotation ... annotations) {
        this.addAnnotations(annotations);
        return this;
    }

    @Nonnull
    public StandardProperties<V> withAnnotations(@Nullable Iterable<? extends Annotation> annotations) {
        this.addAnnotations(annotations);
        return this;
    }

    @Nonnull
    public StandardProperties<V> withProperties(Property<?> ... properties) {
        if (properties != null) {
            for (Property<?> property : properties) {
                this._idToProperty.put(property.getId(), property);
            }
        }
        return this;
    }

    @Nonnull
    public StandardProperties<V> withProperties(@Nullable Iterable<? extends Property<? extends V>> properties) {
        if (properties != null) {
            for (Property<V> property : properties) {
                this._idToProperty.put(property.getId(), property);
            }
        }
        return this;
    }
}

