/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.locela.api.java.format;

import java.io.IOException;
import java.io.Writer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.echocat.locela.api.java.format.FormatterFactory;
import org.echocat.locela.api.java.format.FormatterSupport;
import org.echocat.locela.api.java.utils.StringUtils;

@ThreadSafe
public class DateTimeFormatter
extends FormatterSupport {
    private static final FormatterFactory<DateTimeFormatter> FACTORY_INSTANCE = new Factory();
    @Nonnull
    private final DateFormat _format;
    @Nonnull
    private final String _plainFormat;

    @Nonnull
    public static FormatterFactory<DateTimeFormatter> dateTimeFormatterFactory() {
        return FACTORY_INSTANCE;
    }

    public DateTimeFormatter(@Nonnull Locale locale, @Nullable DateFormat format) {
        super(locale);
        if (format != null) {
            this._format = format;
            this._plainFormat = "<raw>";
        } else {
            this._format = Pattern.DEFAULT.toFormat(locale);
            this._plainFormat = Pattern.DEFAULT.toString();
        }
    }

    public DateTimeFormatter(@Nonnull Locale locale, @Nullable Pattern pattern) {
        super(locale);
        Pattern nonNullPattern = pattern != null ? pattern : Pattern.DEFAULT;
        this._format = nonNullPattern.toFormat(locale);
        this._plainFormat = nonNullPattern.toString();
    }

    public DateTimeFormatter(@Nonnull Locale locale, @Nullable String pattern) {
        super(locale);
        this._format = this.evaluate(locale, pattern);
        this._plainFormat = StringUtils.isEmpty(pattern) ? Pattern.DEFAULT.toString() : pattern;
    }

    @Override
    public void format(@Nullable Object value, @Nonnull Writer to) throws IOException {
        if (value != null) {
            to.write(this._format.format(value));
        }
    }

    @Nonnull
    protected DateFormat getFormat() {
        return this._format;
    }

    @Nonnull
    protected DateFormat evaluate(@Nonnull Locale locale, @Nullable String pattern) {
        Pattern predefined;
        DateFormat result = StringUtils.isEmpty(pattern) ? Pattern.DEFAULT.toFormat(locale) : ((predefined = (Pattern)((Object)Pattern.NAME_TO_PATTERN.get(pattern))) != null ? predefined.toFormat(locale) : new SimpleDateFormat(pattern, locale));
        return result;
    }

    public String toString() {
        return "datetime," + this._plainFormat;
    }

    @ThreadSafe
    protected static class Factory
    implements FormatterFactory<DateTimeFormatter> {
        protected Factory() {
        }

        @Override
        @Nonnull
        public String getId() {
            return "datetime";
        }

        @Override
        @Nonnull
        public DateTimeFormatter createBy(@Nullable Locale locale, @Nullable String pattern, @Nonnull FormatterFactory<?> root) {
            return new DateTimeFormatter(locale != null ? locale : Locale.US, pattern);
        }
    }

    public static enum Pattern {
        DEFAULT("default", 2),
        SHORT("short", 3),
        MEDIUM("medium", 2),
        LONG("long", 1),
        FULL("full", 0);

        private static final Map<String, Pattern> NAME_TO_PATTERN;
        @Nonnegative
        private final int _dateFormatValue;
        @Nonnull
        private final String _id;

        private Pattern(String id, int dateFormatValue) {
            this._id = id;
            this._dateFormatValue = dateFormatValue;
        }

        public String toString() {
            return this.getId();
        }

        @Nonnull
        private static Map<String, Pattern> createNameToPattern() {
            Pattern[] values = Pattern.values();
            HashMap<String, Pattern> result = new HashMap<String, Pattern>(values.length, 1.0f);
            for (Pattern pattern : values) {
                result.put(pattern.getId(), pattern);
            }
            return result;
        }

        @Nonnull
        public DateFormat toFormat(@Nonnull Locale locale) {
            return DateFormat.getDateTimeInstance(this._dateFormatValue, this._dateFormatValue, locale);
        }

        @Nonnull
        public String getId() {
            return this._id;
        }

        static {
            NAME_TO_PATTERN = Pattern.createNameToPattern();
        }
    }
}

