/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.locela.api.java.properties;

import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;
import org.echocat.locela.api.java.annotations.AnnotationContainerSupport;
import org.echocat.locela.api.java.properties.Properties;
import org.echocat.locela.api.java.properties.Property;

@NotThreadSafe
public abstract class PropertiesSupport<V>
extends AnnotationContainerSupport
implements Properties<V> {
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        boolean first = true;
        for (Property<V> property : this) {
            if (first) {
                first = false;
            } else {
                sb.append(',');
            }
            sb.append(property);
        }
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        boolean result;
        if (this == o) {
            result = true;
        } else if (!(o instanceof Properties)) {
            result = false;
        } else {
            Set<String> thatKeys;
            Properties that = (Properties)o;
            Set<String> keys = this.getKeysOf(this);
            if (keys.equals(thatKeys = this.getKeysOf(that))) {
                result = true;
                for (String key : keys) {
                    if (this.get(key).equals(that.get(key))) continue;
                    result = false;
                    break;
                }
            } else {
                result = false;
            }
        }
        return result;
    }

    @Nonnull
    protected Set<String> getKeysOf(@Nonnull Properties<?> properties) {
        TreeSet<String> keys = new TreeSet<String>();
        for (Property property : properties) {
            keys.add(property.getId());
        }
        return keys;
    }

    public int hashCode() {
        int result = 0;
        for (String key : this.getKeysOf(this)) {
            result = 31 * result + this.get(key).hashCode();
        }
        return result;
    }

    @Override
    public Iterator<Property<V>> iterator() {
        return this.getProperties().iterator();
    }

    @Nonnull
    protected abstract Iterable<? extends Property<V>> getProperties();
}

