/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.locela.api.java.utils;

import java.util.Enumeration;
import java.util.Iterator;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.echocat.locela.api.java.messages.Message;
import org.echocat.locela.api.java.messages.Messages;
import org.echocat.locela.api.java.messages.MessagesSupport;
import org.echocat.locela.api.java.utils.CollectionUtils;

public class MessagesUtils {
    @Nonnull
    private static final Messages EMPTY_MESSAGES = new EmptyMessages();

    @Nonnull
    public static Messages emptyMessages() {
        return EMPTY_MESSAGES;
    }

    @Nonnull
    public static ResourceBundle toResourceBundle(@Nullable Messages messages) {
        return MessagesUtils.toResourceBundle(messages, null);
    }

    @Nonnull
    public static ResourceBundle toResourceBundle(@Nullable Messages messages, @Nullable Locale locale) {
        return new MessagesBasedResourceBundle(messages, locale);
    }

    protected static class MessagesBasedResourceBundle
    extends ResourceBundle {
        @Nullable
        private final Messages _messages;
        @Nullable
        private final Locale _locale;

        public MessagesBasedResourceBundle(@Nullable Messages messages, @Nullable Locale locale) {
            this._locale = locale;
            this._messages = messages != null ? messages : MessagesUtils.emptyMessages();
        }

        @Override
        protected Object handleGetObject(String key) {
            if (!this._messages.contains(key)) {
                return null;
            }
            return this._messages.get(key).get();
        }

        @Override
        public Enumeration<String> getKeys() {
            final Iterator source = this._messages.iterator();
            return new Enumeration<String>(){

                @Override
                public boolean hasMoreElements() {
                    return source.hasNext();
                }

                @Override
                public String nextElement() {
                    return ((Message)source.next()).getId();
                }
            };
        }

        @Override
        public Locale getLocale() {
            return this._locale;
        }
    }

    private static class EmptyMessages
    extends MessagesSupport {
        private EmptyMessages() {
        }

        @Override
        @Nullable
        public Message find(@Nonnull String id) {
            return null;
        }

        @Override
        public boolean contains(@Nonnull String id) {
            return false;
        }

        @Override
        public Iterator<Message> iterator() {
            return CollectionUtils.emptyIterator();
        }
    }
}

