/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.locela.api.java.properties;

import javax.annotation.Nonnull;
import org.echocat.locela.api.java.properties.Property;
import org.echocat.locela.api.java.properties.PropertyFormatter;

public class StandardPropertyFormatter
implements PropertyFormatter {
    private static final StandardPropertyFormatter INSTANCE = new StandardPropertyFormatter();

    @Nonnull
    public static StandardPropertyFormatter propertyFormatter() {
        return INSTANCE;
    }

    @Override
    @Nonnull
    public String format(@Nonnull Property<String> property) {
        StringBuilder sb = new StringBuilder();
        this.append(property.getId(), sb, true);
        sb.append(" = ");
        this.append(property.get(), sb, false);
        return sb.toString();
    }

    protected void append(@Nonnull String what, @Nonnull StringBuilder to, boolean escapeWhiteSpaces) {
        char[] chars;
        for (char c : chars = what != null ? what.toCharArray() : new char[]{}) {
            if (this.isEscapeNeeded(c)) {
                to.append('\\').append(c);
                continue;
            }
            if (c == '\n') {
                to.append("\\n");
                continue;
            }
            if (c == '\r') {
                to.append("\\r");
                continue;
            }
            if (c == '\t') {
                to.append("\\t");
                continue;
            }
            if (c == '\f') {
                to.append("\\f");
                continue;
            }
            if (escapeWhiteSpaces && c == ' ') {
                to.append("\\ ");
                continue;
            }
            to.append(c);
        }
    }

    protected boolean isEscapeNeeded(char c) {
        return c == ':' || c == '=' || c == '\\';
    }
}

