/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.locela.api.java.format;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.echocat.locela.api.java.format.Formatter;
import org.echocat.locela.api.java.format.FormatterFactory;
import org.echocat.locela.api.java.format.FormatterSupport;

@ThreadSafe
public class ChoiceFormatter
extends FormatterSupport {
    private static final FormatterFactory<ChoiceFormatter> FACTORY_INSTANCE = new Factory();
    @Nonnull
    private final List<Condition> _conditions;

    @Nonnull
    public static FormatterFactory<ChoiceFormatter> choiceFormatterFactory() {
        return FACTORY_INSTANCE;
    }

    public ChoiceFormatter(@Nonnull Locale locale, @Nullable List<Condition> conditions) {
        super(locale);
        this._conditions = conditions != null ? conditions : Collections.emptyList();
    }

    public ChoiceFormatter(@Nonnull Locale locale, @Nullable String pattern, @Nonnull FormatterFactory<?> root) {
        super(locale);
        this._conditions = this.parse(pattern, root);
    }

    @Nonnull
    protected List<Condition> parse(@Nullable String pattern, @Nonnull FormatterFactory<?> root) {
        ArrayList<Condition> conditions = new ArrayList<Condition>();
        char[] chars = pattern != null ? pattern.toCharArray() : new char[]{};
        String test = null;
        Operator operator = null;
        for (int i = 0; i < chars.length; ++i) {
            if (test == null) {
                ExtractionWithOperator testAndOperator = this.extractTestAndOperator(chars, i);
                test = testAndOperator.getContent();
                operator = testAndOperator.getOperator();
                i = testAndOperator.getEnd();
                continue;
            }
            Extraction extraction = this.extractPattern(chars, i);
            String subPattern = extraction.getContent();
            Object subFormat = root.createBy(this.getLocale(), subPattern, root);
            Condition condition = new Condition(test, operator, (Formatter)subFormat);
            conditions.add(condition);
            i = extraction.getEnd();
            test = null;
            operator = null;
        }
        if (test != null) {
            throw new IllegalArgumentException("Unexpected end of pattern: " + pattern);
        }
        return conditions;
    }

    @Nonnull
    protected ExtractionWithOperator extractTestAndOperator(@Nonnull char[] chars, @Nonnegative int begin) throws IllegalArgumentException {
        int end = begin;
        boolean inEscape = false;
        StringBuilder sb = new StringBuilder();
        Operator operator = null;
        for (int i = begin; operator == null && i < chars.length; ++i) {
            char c = chars[i];
            if (c == '\'') {
                if (i + 1 <= chars.length && chars[i + 1] == '\'') {
                    sb.append('\'');
                    ++i;
                    continue;
                }
                inEscape = !inEscape;
                continue;
            }
            if (inEscape) {
                sb.append(c);
                continue;
            }
            if (c == '|') {
                throw new IllegalArgumentException("Unexpected separation character ' of pattern: " + new String(chars, begin, chars.length - begin));
            }
            operator = Operator.findOperatorFor(c);
            if (operator != null) {
                end = i;
                continue;
            }
            sb.append(c);
        }
        if (operator == null) {
            throw new IllegalArgumentException("Unexpected end of pattern: " + new String(chars, begin, chars.length - begin));
        }
        return new ExtractionWithOperator(sb.toString(), begin, end, operator);
    }

    @Nonnull
    protected Extraction extractPattern(@Nonnull char[] chars, @Nonnegative int begin) throws IllegalArgumentException {
        int i;
        boolean inEscape = false;
        StringBuilder sb = new StringBuilder();
        for (i = begin; i < chars.length; ++i) {
            char c = chars[i];
            if (c == '\'') {
                if (i + 1 <= chars.length && chars[i + 1] == '\'') {
                    sb.append('\'');
                    ++i;
                    continue;
                }
                inEscape = !inEscape;
                continue;
            }
            if (inEscape) {
                sb.append(c);
                continue;
            }
            if (c == '|') break;
            sb.append(c);
        }
        return new Extraction(sb.toString(), begin, i);
    }

    @Override
    public void format(@Nullable Object value, @Nonnull Writer to) throws IOException {
        for (Condition condition : this._conditions) {
            if (!condition.apply(value)) continue;
            condition.getSubFormat().format(value, to);
            break;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("choice,");
        boolean first = true;
        for (Condition condition : this._conditions) {
            if (first) {
                first = false;
            } else {
                sb.append('|');
            }
            sb.append(condition);
        }
        return sb.toString();
    }

    protected static class ExtractionWithOperator
    extends Extraction {
        @Nonnull
        private final Operator _operator;

        public ExtractionWithOperator(@Nonnull String content, @Nonnegative int begin, @Nonnegative int end, @Nonnull Operator operator) {
            super(content, begin, end);
            this._operator = operator;
        }

        @Nonnull
        public Operator getOperator() {
            return this._operator;
        }
    }

    @ThreadSafe
    protected static class Extraction {
        @Nonnull
        private final String _content;
        @Nonnegative
        private final int _begin;
        @Nonnegative
        private final int _end;

        public Extraction(@Nonnull String content, int begin, int end) {
            this._content = content;
            this._begin = begin;
            this._end = end;
        }

        @Nonnull
        public String getContent() {
            return this._content;
        }

        @Nonnegative
        public int getBegin() {
            return this._begin;
        }

        @Nonnegative
        public int getEnd() {
            return this._end;
        }
    }

    @ThreadSafe
    protected static class Factory
    implements FormatterFactory<ChoiceFormatter> {
        protected Factory() {
        }

        @Override
        @Nonnull
        public String getId() {
            return "choice";
        }

        @Override
        @Nonnull
        public ChoiceFormatter createBy(@Nullable Locale locale, @Nullable String pattern, @Nonnull FormatterFactory<?> root) {
            return new ChoiceFormatter(locale != null ? locale : Locale.US, pattern, root);
        }
    }

    public static enum Operator {
        equals('#'),
        greaterThan('<');

        private final char _character;

        private Operator(char character) {
            this._character = character;
        }

        public char getCharacter() {
            return this._character;
        }

        public String toString() {
            return Character.toString(this.getCharacter());
        }

        @Nullable
        public static Operator findOperatorFor(char c) {
            Operator result = null;
            for (Operator candidate : Operator.values()) {
                if (c != candidate.getCharacter()) continue;
                result = candidate;
                break;
            }
            return result;
        }
    }

    @ThreadSafe
    public static class Condition {
        @Nonnull
        private final String _test;
        @Nullable
        private final Double _testAsDouble;
        private final boolean _testAsBoolean;
        @Nonnull
        private final Operator _operator;
        @Nonnull
        private final Formatter _subFormat;

        public Condition(@Nonnull String test, @Nonnull Operator operator, @Nonnull Formatter subFormat) {
            this._test = test;
            this._operator = operator;
            this._subFormat = subFormat;
            this._testAsDouble = this.toDouble(test);
            this._testAsBoolean = this.toBoolean(test);
        }

        @Nullable
        private Double toDouble(@Nonnull String test) {
            Double result;
            try {
                result = Double.valueOf(test);
            }
            catch (NumberFormatException ignored) {
                result = "".equals(test) || "null".equals(test) ? Double.valueOf(0.0) : null;
            }
            return result;
        }

        private boolean toBoolean(@Nonnull String test) {
            return "true".equalsIgnoreCase(test) || "on".equalsIgnoreCase(test) || "1".equals(test);
        }

        @Nonnull
        public Object getTest() {
            return this._test;
        }

        @Nonnull
        public Operator getOperator() {
            return this._operator;
        }

        @Nonnull
        public Formatter getSubFormat() {
            return this._subFormat;
        }

        public boolean apply(@Nullable Object value) {
            boolean result = value == null ? this.applyNullValue() : (value instanceof Number ? this.applyNumberValue((Number)value) : (value instanceof Boolean ? this.applyBooleanValue((Boolean)value) : (value instanceof String ? this.applyStringValue(value.toString()) : false)));
            return result;
        }

        protected boolean applyBooleanValue(@Nonnull Boolean value) {
            if (this._operator != Operator.equals) {
                throw new UnsupportedOperationException("Operator " + (Object)((Object)this._operator) + " is not supported.");
            }
            boolean result = this._testAsBoolean == value;
            return result;
        }

        protected boolean applyNumberValue(@Nonnull Number value) {
            boolean result;
            if (this._testAsDouble == null) {
                result = false;
            } else if (this._operator == Operator.equals) {
                result = this._testAsDouble.doubleValue() == value.doubleValue();
            } else if (this._operator == Operator.greaterThan) {
                result = this._testAsDouble < value.doubleValue();
            } else {
                throw new UnsupportedOperationException("Operator " + (Object)((Object)this._operator) + " is not supported.");
            }
            return result;
        }

        protected boolean applyStringValue(@Nonnull String value) {
            boolean result;
            if (this._operator == Operator.equals) {
                result = this._test.equals(value);
            } else if (this._operator == Operator.greaterThan) {
                result = this._test.compareTo(value) < 0;
            } else {
                throw new UnsupportedOperationException("Operator " + (Object)((Object)this._operator) + " is not supported.");
            }
            return result;
        }

        protected boolean applyNullValue() {
            return this._test.equals("0") || this._test.equals("") || this._test.equals("null");
        }

        public String toString() {
            return this._test + (Object)((Object)this._operator) + this._subFormat;
        }
    }
}

