/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.locela.api.java.format;

import java.io.IOException;
import java.io.Writer;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.echocat.locela.api.java.format.FormatterFactory;
import org.echocat.locela.api.java.format.FormatterSupport;
import org.echocat.locela.api.java.utils.StringUtils;

@ThreadSafe
public class NumberFormatter
extends FormatterSupport {
    private static final FormatterFactory<NumberFormatter> FACTORY_INSTANCE = new Factory();
    @Nonnull
    private final NumberFormat _format;
    @Nullable
    private final String _plainFormat;

    @Nonnull
    public static FormatterFactory<NumberFormatter> numberFormatterFactory() {
        return FACTORY_INSTANCE;
    }

    public NumberFormatter(@Nonnull Locale locale, @Nullable NumberFormat format) {
        super(locale);
        if (format != null) {
            this._format = format;
            this._plainFormat = "<raw>";
        } else {
            this._format = Pattern.DEFAULT.toFormat(locale);
            this._plainFormat = Pattern.DEFAULT.toString();
        }
    }

    public NumberFormatter(@Nonnull Locale locale, @Nullable Pattern pattern) {
        super(locale);
        this._format = pattern != null ? pattern.toFormat(locale) : Pattern.DEFAULT.toFormat(locale);
        this._plainFormat = pattern != null ? pattern.getId() : Pattern.DEFAULT.getId();
    }

    public NumberFormatter(@Nonnull Locale locale, @Nullable String pattern) {
        super(locale);
        FormatAndPattern formatAndPattern = this.evaluate(locale, pattern);
        this._plainFormat = formatAndPattern.getPattern();
        this._format = formatAndPattern.getFormat();
    }

    @Override
    public void format(@Nullable Object value, @Nonnull Writer to) throws IOException {
        to.write(this._format.format(value != null ? value : Integer.valueOf(0)));
    }

    @Nonnull
    protected FormatAndPattern evaluate(@Nonnull Locale locale, @Nullable String pattern) {
        Pattern predefined;
        FormatAndPattern result = StringUtils.isEmpty(pattern) ? new FormatAndPattern(Pattern.DEFAULT.toFormat(locale), Pattern.DEFAULT.getId()) : ((predefined = (Pattern)((Object)Pattern.NAME_TO_PATTERN.get(pattern))) != null ? new FormatAndPattern(predefined.toFormat(locale), predefined.getId()) : new FormatAndPattern(new DecimalFormat(pattern, DecimalFormatSymbols.getInstance(locale)), pattern));
        return result;
    }

    @Nonnull
    protected NumberFormat getFormat() {
        return this._format;
    }

    public String toString() {
        return "number," + this._plainFormat;
    }

    @ThreadSafe
    protected static class Factory
    implements FormatterFactory<NumberFormatter> {
        protected Factory() {
        }

        @Override
        @Nonnull
        public String getId() {
            return "number";
        }

        @Override
        @Nonnull
        public NumberFormatter createBy(@Nullable Locale locale, @Nullable String pattern, @Nonnull FormatterFactory<?> root) {
            return new NumberFormatter(locale != null ? locale : Locale.US, pattern);
        }
    }

    public static enum Pattern {
        DEFAULT("default"){

            @Override
            public NumberFormat toFormat(@Nonnull Locale locale) {
                return NumberFormat.getInstance(locale);
            }
        }
        ,
        INTEGER("integer"){

            @Override
            public NumberFormat toFormat(@Nonnull Locale locale) {
                return NumberFormat.getIntegerInstance(locale);
            }
        }
        ,
        CURRENCY("currency"){

            @Override
            public NumberFormat toFormat(@Nonnull Locale locale) {
                return NumberFormat.getCurrencyInstance(locale);
            }
        }
        ,
        PERCENT("percent"){

            @Override
            public NumberFormat toFormat(@Nonnull Locale locale) {
                return NumberFormat.getPercentInstance(locale);
            }
        };

        private static final Map<String, Pattern> NAME_TO_PATTERN;
        @Nonnull
        private final String _id;

        private Pattern(String id) {
            this._id = id;
        }

        @Nonnull
        private static Map<String, Pattern> createNameToPattern() {
            Pattern[] values = Pattern.values();
            HashMap<String, Pattern> result = new HashMap<String, Pattern>(values.length, 1.0f);
            for (Pattern pattern : values) {
                result.put(pattern.getId(), pattern);
            }
            return result;
        }

        @Nonnull
        public String getId() {
            return this._id;
        }

        public abstract NumberFormat toFormat(@Nonnull Locale var1);

        static {
            NAME_TO_PATTERN = Pattern.createNameToPattern();
        }
    }

    @ThreadSafe
    protected static class FormatAndPattern {
        @Nonnull
        private final NumberFormat _format;
        @Nonnull
        private final String _pattern;

        public FormatAndPattern(@Nonnull NumberFormat format, @Nonnull String pattern) {
            this._format = format;
            this._pattern = pattern;
        }

        @Nonnull
        public NumberFormat getFormat() {
            return this._format;
        }

        @Nonnull
        public String getPattern() {
            return this._pattern;
        }
    }
}

