/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.locela.api.java.messages;

import java.util.Iterator;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.echocat.locela.api.java.format.FormatterFactory;
import org.echocat.locela.api.java.messages.Message;
import org.echocat.locela.api.java.messages.MessagesSupport;
import org.echocat.locela.api.java.messages.PropertyMessage;
import org.echocat.locela.api.java.properties.Properties;
import org.echocat.locela.api.java.properties.Property;
import org.echocat.locela.api.java.utils.ConvertingIterator;

public class PropertiesMessages
extends MessagesSupport {
    @Nullable
    private final Locale _locale;
    @Nonnull
    private final Properties<?> _properties;
    @Nullable
    private final FormatterFactory<?> _formatterFactory;

    @Nonnull
    public static PropertiesMessages messagesFor(@Nullable Locale locale, @Nonnull Properties<?> properties) {
        return PropertiesMessages.messagesFor(locale, properties, null);
    }

    @Nonnull
    public static PropertiesMessages messagesFor(@Nullable Locale locale, @Nonnull Properties<?> properties, @Nullable FormatterFactory<?> formatterFactory) {
        return new PropertiesMessages(locale, properties, formatterFactory);
    }

    public PropertiesMessages(@Nullable Locale locale, @Nonnull Properties<?> properties, @Nullable FormatterFactory<?> formatterFactory) {
        this._locale = locale;
        this._properties = properties;
        this._formatterFactory = formatterFactory;
    }

    @Override
    @Nonnull
    public Message find(@Nonnull String id) {
        Property<?> property = this.properties().get(id);
        return property != null ? this.propertyMessageFor(property) : null;
    }

    @Nonnull
    protected PropertyMessage propertyMessageFor(@Nonnull Property<?> property) {
        return new PropertyMessage(this.locale(), property, this.formatterFactory());
    }

    @Override
    public boolean contains(@Nonnull String id) {
        return this.properties().contains(id);
    }

    @Override
    public Iterator<Message> iterator() {
        return new ConvertingIterator<Property<?>, Message>(this.properties().iterator()){

            @Override
            protected Message convert(@Nonnull Property<?> input) {
                return PropertiesMessages.this.propertyMessageFor(input);
            }
        };
    }

    @Nonnull
    protected Properties<?> properties() {
        return this._properties;
    }

    @Nullable
    protected FormatterFactory<?> formatterFactory() {
        return this._formatterFactory;
    }

    @Nullable
    protected Locale locale() {
        return this._locale;
    }
}

