/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.locela.api.java.properties;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;

public interface Line {
    public void write(@Nonnull Writer var1) throws IOException;

    @ThreadSafe
    public static class EmptyLine
    extends LineSupport {
        @Override
        public void write(@Nonnull Writer to) throws IOException {
        }
    }

    @ThreadSafe
    public static class CommentLine
    extends LineWithContent {
        private static final char[] PREFIX = new char[]{'#', ' '};

        public CommentLine(@Nonnull String content) {
            super(content);
        }

        @Override
        public void write(@Nonnull Writer to) throws IOException {
            char[] chars = this.getContent().trim().toCharArray();
            if (chars.length > 0) {
                to.write(PREFIX);
                char lastNewLineCharacter = '\u0000';
                for (char c : chars) {
                    if (lastNewLineCharacter != '\u0000' && (lastNewLineCharacter == c || c != '\r' && c != '\n')) {
                        to.write(PREFIX);
                        lastNewLineCharacter = '\u0000';
                    }
                    to.write(c);
                    if (lastNewLineCharacter != '\u0000' || c != '\r' && c != '\n') continue;
                    lastNewLineCharacter = c;
                }
                to.write(10);
            }
        }
    }

    @ThreadSafe
    public static class PropertyLine
    extends LineWithContent {
        public PropertyLine(@Nonnull String content) {
            super(content);
        }

        @Override
        public void write(@Nonnull Writer to) throws IOException {
            to.write(this.getContent());
            to.write(10);
        }
    }

    @ThreadSafe
    public static abstract class LineWithContent
    extends LineSupport {
        @Nonnull
        private final String _content;

        public LineWithContent(@Nonnull String content) {
            this._content = content;
        }

        @Nonnull
        public String getContent() {
            return this._content;
        }
    }

    @ThreadSafe
    public static abstract class LineSupport
    implements Line {
        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public String toString() {
            try (StringWriter writer = new StringWriter();){
                this.write(writer);
                String string = writer.toString();
                return string;
            }
            catch (IOException e) {
                throw new RuntimeException("Problems while write to StringWriter?", e);
            }
        }
    }
}

