/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.locela.api.java.properties;

import java.io.IOException;
import java.io.Reader;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.echocat.locela.api.java.annotations.Annotation;
import org.echocat.locela.api.java.annotations.AnnotationsParser;
import org.echocat.locela.api.java.properties.Line;
import org.echocat.locela.api.java.properties.Properties;
import org.echocat.locela.api.java.properties.PropertiesLineReader;
import org.echocat.locela.api.java.properties.PropertiesReader;
import org.echocat.locela.api.java.properties.Property;
import org.echocat.locela.api.java.properties.PropertyParser;
import org.echocat.locela.api.java.properties.StandardProperties;
import org.echocat.locela.api.java.properties.StandardPropertiesLineReader;
import org.echocat.locela.api.java.properties.StandardPropertyParser;

public class StandardPropertiesReader
implements PropertiesReader {
    private static final StandardPropertiesReader INSTANCE = new StandardPropertiesReader();
    @Nonnull
    private final AnnotationsParser _annotationsParser;
    @Nonnull
    private final PropertyParser _propertyParser;

    @Nonnull
    public static StandardPropertiesReader propertiesReader() {
        return INSTANCE;
    }

    public StandardPropertiesReader() {
        this(null, null);
    }

    public StandardPropertiesReader(@Nullable AnnotationsParser annotationsParser, @Nullable PropertyParser propertyParser) {
        this._annotationsParser = annotationsParser != null ? annotationsParser : AnnotationsParser.annotationsParser();
        this._propertyParser = propertyParser != null ? propertyParser : StandardPropertyParser.propertyParser();
    }

    @Override
    @Nonnull
    public Properties<String> read(@Nonnull Reader reader) throws IOException {
        return this.read(new StandardPropertiesLineReader(reader));
    }

    @Nonnull
    public Properties<String> read(@Nonnull PropertiesLineReader reader) throws IOException {
        Iterable<Annotation> annotations;
        StandardProperties<String> properties = new StandardProperties<String>();
        StringBuilder commentLines = new StringBuilder();
        boolean commentFound = false;
        boolean propertyFound = false;
        boolean headCommentAdded = false;
        Line line = reader.read();
        while (line != null) {
            if (line instanceof Line.CommentLine) {
                commentFound = true;
                commentLines.append(((Line.LineWithContent)line).getContent()).append('\n');
            } else if (line instanceof Line.PropertyLine) {
                propertyFound = true;
                annotations = this.toAnnotations(commentLines.toString());
                commentLines.setLength(0);
                String content = ((Line.LineWithContent)line).getContent();
                Property<String> property = this.propertyParser().parse(content, annotations);
                properties.add(property);
            } else if (line instanceof Line.EmptyLine && commentFound && !propertyFound && !headCommentAdded) {
                headCommentAdded = true;
                annotations = this.toAnnotations(commentLines.toString());
                commentLines.setLength(0);
                properties.withAnnotations(annotations);
            }
            line = reader.read();
        }
        if (commentFound && !propertyFound && !headCommentAdded) {
            annotations = this.toAnnotations(commentLines.toString());
            commentLines.setLength(0);
            properties.withAnnotations(annotations);
        }
        return properties;
    }

    @Nonnull
    protected Iterable<Annotation> toAnnotations(@Nonnull String comment) {
        return this.annotationsParser().parse(comment);
    }

    @Nonnull
    protected AnnotationsParser annotationsParser() {
        return this._annotationsParser;
    }

    @Nonnull
    protected PropertyParser propertyParser() {
        return this._propertyParser;
    }
}

