/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.locela.api.java.properties;

import java.io.IOException;
import java.io.Writer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.echocat.locela.api.java.annotations.AnnotationContainer;
import org.echocat.locela.api.java.annotations.AnnotationsFormatter;
import org.echocat.locela.api.java.properties.Line;
import org.echocat.locela.api.java.properties.Properties;
import org.echocat.locela.api.java.properties.PropertiesWriter;
import org.echocat.locela.api.java.properties.Property;
import org.echocat.locela.api.java.properties.PropertyFormatter;
import org.echocat.locela.api.java.properties.StandardPropertyFormatter;

public class StandardPropertiesWriter
implements PropertiesWriter {
    private static final StandardPropertiesWriter INSTANCE = new StandardPropertiesWriter();
    @Nonnull
    private final PropertyFormatter _propertyFormatter;
    @Nonnull
    private final AnnotationsFormatter _annotationsFormatter;

    @Nonnull
    public static StandardPropertiesWriter propertyWriter() {
        return INSTANCE;
    }

    public StandardPropertiesWriter() {
        this(StandardPropertyFormatter.propertyFormatter(), AnnotationsFormatter.annotationsFormatter());
    }

    public StandardPropertiesWriter(@Nonnull PropertyFormatter propertyFormatter, @Nonnull AnnotationsFormatter annotationsFormatter) {
        this._propertyFormatter = propertyFormatter;
        this._annotationsFormatter = annotationsFormatter;
    }

    @Override
    public void write(@Nullable Properties<String> properties, @Nonnull Writer to) throws IOException {
        if (properties != null) {
            this.writeHead(properties, to);
            for (Property property : properties) {
                this.writeProperty(property, to);
            }
        }
    }

    protected void writeHead(@Nonnull Properties<String> of, @Nonnull Writer to) throws IOException {
        if (this.writeAnnotations(of, to)) {
            to.write(10);
        }
    }

    protected void writeProperty(@Nonnull Property<String> property, @Nonnull Writer to) throws IOException {
        this.writeAnnotations(property, to);
        String formatted = this.propertyFormatter().format(property);
        to.write(formatted);
        to.write(10);
    }

    protected boolean writeAnnotations(@Nullable AnnotationContainer of, @Nonnull Writer to) throws IOException {
        boolean annotationsWritten;
        String formatted = this.annotationsFormatter().format(of.annotations());
        if (!formatted.isEmpty()) {
            Line.CommentLine line = new Line.CommentLine(formatted);
            line.write(to);
            annotationsWritten = true;
        } else {
            annotationsWritten = false;
        }
        return annotationsWritten;
    }

    @Nonnull
    public PropertyFormatter propertyFormatter() {
        return this._propertyFormatter;
    }

    @Nonnull
    public AnnotationsFormatter annotationsFormatter() {
        return this._annotationsFormatter;
    }
}

