/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.locela.api.java.messages;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.echocat.locela.api.java.messages.CombinedMessages;
import org.echocat.locela.api.java.messages.FileAccessor;
import org.echocat.locela.api.java.messages.Messages;
import org.echocat.locela.api.java.messages.MessagesProvider;
import org.echocat.locela.api.java.messages.MessagesProviderSupport;
import org.echocat.locela.api.java.messages.StandardMessagesProvider;

public class RecursiveMessagesProvider
extends MessagesProviderSupport {
    private static final RecursiveMessagesProvider INSTANCE = new RecursiveMessagesProvider();
    @Nonnull
    private final MessagesProvider _delegate;

    @Nonnull
    public static RecursiveMessagesProvider recursiveMessagesProvider() {
        return INSTANCE;
    }

    public RecursiveMessagesProvider() {
        this(null);
    }

    public RecursiveMessagesProvider(@Nullable MessagesProvider delegate) {
        this._delegate = delegate != null ? delegate : StandardMessagesProvider.messagesProvider();
    }

    @Override
    @Nullable
    public Messages provideBy(@Nullable Locale locale, @Nonnull FileAccessor accessor, @Nonnull String baseFile) throws IOException {
        ArrayList<Messages> stack = new ArrayList<Messages>();
        String current = this.getParent(baseFile);
        this.addIfExists(locale, accessor, baseFile, stack);
        while (current != null) {
            this.addIfExists(locale, accessor, current + "/messages.properties", stack);
            current = this.getParent(current);
        }
        return new CombinedMessages(stack);
    }

    protected void addIfExists(@Nullable Locale locale, @Nonnull FileAccessor accessor, @Nonnull String currentBaseFile, @Nonnull List<Messages> stack) throws IOException {
        Messages candidate = this.delegate().provideBy(locale, accessor, currentBaseFile);
        if (candidate != null) {
            stack.add(candidate);
        }
    }

    @Nullable
    protected String getParent(@Nullable String of) {
        String result;
        if (of == null || of.isEmpty()) {
            result = null;
        } else {
            int lastSlash = of.lastIndexOf(47);
            int lastFileSeparator = of.lastIndexOf(this.systemFileSeparator());
            result = lastFileSeparator >= 0 && lastFileSeparator > lastSlash ? of.substring(0, lastFileSeparator) : (lastSlash >= 0 ? of.substring(0, lastSlash) : null);
        }
        return result;
    }

    protected char systemFileSeparator() {
        return File.separatorChar;
    }

    @Nonnull
    protected MessagesProvider delegate() {
        return this._delegate;
    }
}

