/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.locela.api.java.properties;

import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.echocat.locela.api.java.annotations.Annotation;
import org.echocat.locela.api.java.properties.Property;
import org.echocat.locela.api.java.properties.PropertyParser;
import org.echocat.locela.api.java.properties.StandardProperty;

@ThreadSafe
public class StandardPropertyParser
implements PropertyParser {
    private static final StandardPropertyParser INSTANCE = new StandardPropertyParser();

    @Nonnull
    public static StandardPropertyParser propertyParser() {
        return INSTANCE;
    }

    @Override
    @Nonnull
    public Property<String> parse(@Nonnull String plain, @Nullable Iterable<Annotation> annotations) {
        char[] characters = plain.toCharArray();
        Extraction id = this.extractId(characters);
        Extraction content = this.extractContent(characters, id.getEnd());
        Property<String> property = this.createPropertyBy(annotations, id.getContent(), content.getContent());
        return property;
    }

    @Nonnull
    protected Property<String> createPropertyBy(@Nullable Iterable<Annotation> annotations, @Nonnull String id, @Nullable String content) {
        StandardProperty<String> property = StandardProperty.property(id, String.class).withAnnotations(annotations);
        property.set(content);
        return property;
    }

    @Nonnull
    protected Extraction extractId(@Nonnull char[] characters) {
        char c;
        int i;
        boolean started = false;
        boolean inEscape = false;
        boolean finished = false;
        int lastCharacterAtPosition = 0;
        StringBuilder sb = new StringBuilder();
        for (i = 0; !finished && i < characters.length; ++i) {
            char c2 = characters[i];
            if (inEscape) {
                i += this.handleEscapeCharacter(characters, i, sb);
                inEscape = false;
                started = true;
                lastCharacterAtPosition = sb.length();
                continue;
            }
            if (c2 == ' ' || c2 == '\t') {
                if (!started) continue;
                finished = true;
                continue;
            }
            if (c2 == '\\') {
                inEscape = true;
                continue;
            }
            if (c2 == '=' || c2 == ':') {
                finished = true;
                continue;
            }
            started = true;
            sb.append(c2);
            lastCharacterAtPosition = sb.length();
        }
        sb.setLength(lastCharacterAtPosition);
        for (int j = i; j < characters.length && ((c = characters[j]) == ' ' || c == '\t' || c == '=' || c == ':'); ++j) {
            ++i;
        }
        return new Extraction(sb.toString(), i);
    }

    @Nonnull
    protected Extraction extractContent(@Nonnull char[] characters, @Nonnegative int begin) {
        int i;
        boolean started = false;
        boolean inEscape = false;
        int lastCharacterAtPosition = 0;
        StringBuilder sb = new StringBuilder();
        for (i = begin; i < characters.length; ++i) {
            char c = characters[i];
            if (inEscape) {
                i += this.handleEscapeCharacter(characters, i, sb);
                inEscape = false;
                started = true;
                lastCharacterAtPosition = sb.length();
                continue;
            }
            if (c == ' ' || c == '\t') {
                if (!started) continue;
                sb.append(c);
                continue;
            }
            if (c == '\\') {
                inEscape = true;
                continue;
            }
            started = true;
            sb.append(c);
            lastCharacterAtPosition = sb.length();
        }
        sb.setLength(lastCharacterAtPosition);
        return new Extraction(sb.toString(), i);
    }

    @Nonnegative
    private int handleEscapeCharacter(@Nonnull char[] characters, @Nonnegative int at, @Nonnull StringBuilder addTo) {
        int skippedCharacters;
        char original = characters[at];
        if (original == 'n') {
            addTo.append('\n');
            skippedCharacters = 0;
        } else if (original == 'r') {
            addTo.append('\r');
            skippedCharacters = 0;
        } else if (original == 't') {
            addTo.append('\t');
            skippedCharacters = 0;
        } else if (original == 'f') {
            addTo.append('\f');
            skippedCharacters = 0;
        } else if (original == 'u') {
            if (characters.length > at + 4) {
                int value = 0;
                for (int i = 0; i < 4; ++i) {
                    char c = characters[at + i + 1];
                    if (c >= '0' && c <= '9') {
                        value = (value << 4) + (c - 48);
                        continue;
                    }
                    if (c >= 'a' && c <= 'f') {
                        value = (value << 4) + 10 + (c - 97);
                        continue;
                    }
                    if (c >= 'A' && c <= 'F') {
                        value = (value << 4) + 10 + (c - 65);
                        continue;
                    }
                    throw new IllegalArgumentException("Malformed \\uxxxx encoding.");
                }
                addTo.append((char)value);
                skippedCharacters = 4;
            } else {
                addTo.append(original);
                skippedCharacters = 0;
            }
        } else {
            addTo.append(original);
            skippedCharacters = 0;
        }
        return skippedCharacters;
    }

    protected static class Extraction {
        @Nonnull
        private final String _content;
        @Nonnegative
        private final int _end;

        public Extraction(@Nonnull String content, @Nonnegative int end) {
            this._content = content;
            this._end = end;
        }

        @Nonnull
        public String getContent() {
            return this._content;
        }

        @Nonnegative
        public int getEnd() {
            return this._end;
        }
    }
}

