/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.locela.api.java.support;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.echocat.locela.api.java.messages.FileAccessor;
import org.echocat.locela.api.java.messages.Message;
import org.echocat.locela.api.java.messages.Messages;
import org.echocat.locela.api.java.messages.MessagesProvider;
import org.echocat.locela.api.java.support.LocaleNormalizer;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.context.NoSuchMessageException;

public class MessageProviderBasedMessageSource
implements MessageSource {
    @Nonnull
    private final Map<Locale, Messages> _cache = new LinkedHashMap<Locale, Messages>();
    @Nonnull
    private final ReadWriteLock _lock = new ReentrantReadWriteLock();
    @Nonnull
    private final MessagesProvider _messagesProvider;
    @Nullable
    private final LocaleNormalizer _localeNormalizer;
    @Nullable
    private final Class<?> _type;
    @Nullable
    private final ClassLoader _classLoader;
    @Nullable
    private final File _directory;
    @Nullable
    private final FileAccessor _fileAccessor;
    @Nullable
    private final String _baseFile;
    private Integer _maxCacheEntries = 100;

    public MessageProviderBasedMessageSource(@Nonnull MessagesProvider messagesProvider, @Nullable LocaleNormalizer localeNormalizer, @Nonnull Class<?> type) {
        this._messagesProvider = messagesProvider;
        this._localeNormalizer = localeNormalizer;
        this._type = type;
        this._baseFile = null;
        this._classLoader = null;
        this._directory = null;
        this._fileAccessor = null;
    }

    public MessageProviderBasedMessageSource(@Nonnull MessagesProvider messagesProvider, @Nullable LocaleNormalizer localeNormalizer, @Nonnull Class<?> baseType, @Nonnull String baseFile) {
        this._messagesProvider = messagesProvider;
        this._localeNormalizer = localeNormalizer;
        this._type = baseType;
        this._baseFile = baseFile;
        this._classLoader = null;
        this._directory = null;
        this._fileAccessor = null;
    }

    public MessageProviderBasedMessageSource(@Nonnull MessagesProvider messagesProvider, @Nullable LocaleNormalizer localeNormalizer, @Nonnull ClassLoader loader, @Nonnull String baseFile) {
        this._messagesProvider = messagesProvider;
        this._localeNormalizer = localeNormalizer;
        this._type = null;
        this._baseFile = baseFile;
        this._classLoader = loader;
        this._directory = null;
        this._fileAccessor = null;
    }

    public MessageProviderBasedMessageSource(@Nonnull MessagesProvider messagesProvider, @Nullable LocaleNormalizer localeNormalizer, @Nonnull File directory, @Nonnull String baseFilename) {
        this._messagesProvider = messagesProvider;
        this._localeNormalizer = localeNormalizer;
        this._type = null;
        this._baseFile = baseFilename;
        this._classLoader = null;
        this._directory = directory;
        this._fileAccessor = null;
    }

    public MessageProviderBasedMessageSource(@Nonnull MessagesProvider messagesProvider, @Nullable LocaleNormalizer localeNormalizer, @Nonnull FileAccessor accessor, @Nonnull String baseFile) {
        this._messagesProvider = messagesProvider;
        this._localeNormalizer = localeNormalizer;
        this._type = null;
        this._baseFile = baseFile;
        this._classLoader = null;
        this._directory = null;
        this._fileAccessor = accessor;
    }

    public String getMessage(String code, Object[] args, String defaultMessage, Locale locale) {
        Messages messages = this.messagesFor(locale);
        if (messages == null) {
            return defaultMessage;
        }
        Message message = messages.find(code);
        if (message == null) {
            return defaultMessage;
        }
        return message.format(args);
    }

    public String getMessage(String code, Object[] args, Locale locale) throws NoSuchMessageException {
        Messages messages = this.messagesFor(locale);
        if (messages == null) {
            throw new NoSuchMessageException(code, locale);
        }
        Message message = messages.find(code);
        if (message == null) {
            throw new NoSuchMessageException(code, locale);
        }
        return message.format(args);
    }

    public String getMessage(MessageSourceResolvable resolvable, Locale locale) throws NoSuchMessageException {
        String[] codes;
        for (String code : codes = resolvable.getCodes()) {
            Message message;
            Messages messages = this.messagesFor(locale);
            if (messages == null || (message = messages.find(code)) == null) continue;
            return message.format(resolvable.getArguments());
        }
        String defaultMessage = resolvable.getDefaultMessage();
        if (defaultMessage != null) {
            return defaultMessage;
        }
        if (codes != null && codes.length > 1) {
            throw new NoSuchMessageException(codes[0], locale);
        }
        throw new NoSuchMessageException("unknown", locale);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    protected Messages messagesFor(Locale locale) {
        Messages result;
        Locale targetLocale;
        Locale locale2 = targetLocale = this._localeNormalizer != null ? this._localeNormalizer.normalize(locale) : locale;
        if (this._maxCacheEntries == null) {
            return this.createMessagesFor(targetLocale);
        }
        this._lock.readLock().lock();
        try {
            result = this._cache.get(targetLocale);
        }
        finally {
            this._lock.readLock().unlock();
        }
        if (result == null) {
            this._lock.writeLock().lock();
            try {
                result = this.createMessagesFor(targetLocale);
                this._cache.put(targetLocale, result);
                while (this._cache.size() > this._maxCacheEntries) {
                    Iterator<Locale> i = this._cache.keySet().iterator();
                    if (!i.hasNext()) continue;
                    i.next();
                    i.remove();
                }
            }
            finally {
                this._lock.writeLock().unlock();
            }
        }
        return result;
    }

    @Nullable
    protected Messages createMessagesFor(Locale locale) {
        try {
            if (this._type != null && this._baseFile == null) {
                return this._messagesProvider.provideBy(locale, this._type);
            }
            if (this._type != null && this._baseFile != null) {
                return this._messagesProvider.provideBy(locale, this._type, this._baseFile);
            }
            if (this._classLoader != null && this._baseFile != null) {
                return this._messagesProvider.provideBy(locale, this._classLoader, this._baseFile);
            }
            if (this._directory != null && this._baseFile != null) {
                return this._messagesProvider.provideBy(locale, this._directory, this._baseFile);
            }
            if (this._fileAccessor != null && this._baseFile != null) {
                return this._messagesProvider.provideBy(locale, this._fileAccessor, this._baseFile);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        throw new IllegalArgumentException("There was no valid accessor combination provided.");
    }

    public Integer getMaxCacheEntries() {
        return this._maxCacheEntries;
    }

    @Nonnull
    public MessageProviderBasedMessageSource setMaxCacheEntries(Integer maxCacheEntries) {
        this._maxCacheEntries = maxCacheEntries;
        return this;
    }

    @Nonnull
    protected MessagesProvider messagesProvider() {
        return this._messagesProvider;
    }

    @Nonnull
    protected Map<Locale, Messages> cache() {
        return this._cache;
    }
}

