/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.maven.plugins.daemon;

import java.io.File;
import java.io.IOException;
import java.util.Properties;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.echocat.jomon.process.ExecutableDiscovery;
import org.echocat.maven.plugins.daemon.HanldingDaemonMojoSupport;

public abstract class DaemonMojoSupport
extends HanldingDaemonMojoSupport {
    @Parameter(property="daemon.executable", required=true)
    private String executable;
    @Parameter(property="daemon.executable.environmentVariablesPointingTo")
    private String[] environmentVariablesPointingToExecutable;
    @Parameter(property="daemon.executable.subDirectories")
    private String[] subDirectoriesContainingExecutable;
    @Parameter(property="daemon.executable.autoDetectExtensions", defaultValue="true")
    private boolean autoDetectExtensionsOfExecutable;
    @Parameter(property="daemon.arguments")
    private String[] arguments;
    @Parameter(property="daemon.pidProperty", defaultValue="daemon.pid")
    private String pidProperty;
    @Component(role=MavenProject.class, hint="project")
    private MavenProject project;

    @Nonnull
    protected File getExecutable() throws MojoExecutionException {
        File result;
        String plainExecutable = this.executable;
        if (plainExecutable == null) {
            throw new MojoExecutionException("No executable set.");
        }
        File potentialResult = new File(plainExecutable);
        if (potentialResult.canExecute()) {
            result = potentialResult;
        } else {
            result = ExecutableDiscovery.executableDiscovery().discover(ExecutableDiscovery.Task.executable((String[])new String[]{plainExecutable}).withinEnvironmentVariables(this.getEnvironmentVariablesPointingToExecutable()).searchInSubDirectories(this.getSubDirectoriesContainingExecutable()).autoDetectExtensions(this.isAutoDetectExtensionsOfExecutable()));
            if (result == null) {
                throw new MojoExecutionException("Could not find executable '" + plainExecutable + "'.");
            }
        }
        try {
            return result.getCanonicalFile();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not make path canonical of executable '" + result + "'.", (Exception)e);
        }
    }

    @Nullable
    protected String[] getArguments() throws MojoExecutionException {
        return this.arguments;
    }

    @Nullable
    protected String[] getEnvironmentVariablesPointingToExecutable() {
        return this.environmentVariablesPointingToExecutable;
    }

    @Nullable
    protected String[] getSubDirectoriesContainingExecutable() {
        return this.subDirectoriesContainingExecutable;
    }

    protected boolean isAutoDetectExtensionsOfExecutable() {
        return this.autoDetectExtensionsOfExecutable;
    }

    @Nonnull
    protected String getPidProperty() throws MojoExecutionException {
        String result = this.pidProperty;
        if (result == null) {
            throw new MojoExecutionException("No pidProperty set.");
        }
        return result;
    }

    @Nonnull
    protected MavenProject getProject() throws MojoExecutionException {
        MavenProject result = this.project;
        if (result == null) {
            throw new MojoExecutionException("No project set.");
        }
        return result;
    }

    @Nonnull
    protected Properties getProperties() throws MojoExecutionException {
        return this.getProject().getProperties();
    }
}

